/*
 * Decompiled with CFR 0.152.
 */
package org.slinkyframework.environment.docker.test;

import java.lang.reflect.Field;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slinkyframework.environment.docker.PortSelector;

public class PortSelectorTest {
    @Test
    public void shouldSelectAFreePort() {
        int selectedPort = PortSelector.selectFreePort();
        System.out.println(selectedPort);
        Assert.assertThat((String)"Port", (Object)selectedPort, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @Test
    public void shouldSelectExternalPortAsSameAsInternalPortByDefault() {
        int internalPort = 8080;
        int selectedPort = PortSelector.selectPort((int)internalPort);
        System.out.println(selectedPort);
        Assert.assertThat((String)"Port", (Object)selectedPort, (Matcher)Matchers.is((Object)internalPort));
    }

    @Test
    public void shouldSelectExternalPortFromEnvironmentVariable() throws Exception {
        int internalPort = 8081;
        int externalPort = 9091;
        PortSelectorTest.injectEnvironmentVariable("ENV_DOCKER_PORT_" + internalPort, String.valueOf(externalPort));
        int selectedPort = PortSelector.selectPort((int)internalPort);
        System.out.println(selectedPort);
        Assert.assertThat((String)"Port", (Object)selectedPort, (Matcher)Matchers.is((Object)externalPort));
    }

    @Test
    public void shouldSelectFreePortDueToEmptyEnvironmentVariable() throws Exception {
        int internalPort = 8082;
        PortSelectorTest.injectEnvironmentVariable("ENV_DOCKER_PORT_" + internalPort, "");
        int selectedPort = PortSelector.selectPort((int)internalPort);
        System.out.println(selectedPort);
        Assert.assertThat((String)"Port", (Object)selectedPort, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Assert.assertThat((String)"Port", (Object)selectedPort, (Matcher)Matchers.is((Matcher)Matchers.not((Object)internalPort)));
    }

    private static void injectEnvironmentVariable(String key, String value) throws Exception {
        Class<?> processEnvironment = Class.forName("java.lang.ProcessEnvironment");
        Field unmodifiableMapField = PortSelectorTest.getAccessibleField(processEnvironment, "theUnmodifiableEnvironment");
        Object unmodifiableMap = unmodifiableMapField.get(null);
        PortSelectorTest.injectIntoUnmodifiableMap(key, value, unmodifiableMap);
        Field mapField = PortSelectorTest.getAccessibleField(processEnvironment, "theEnvironment");
        Map map = (Map)mapField.get(null);
        map.put(key, value);
    }

    private static Field getAccessibleField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field;
    }

    private static void injectIntoUnmodifiableMap(String key, String value, Object map) throws ReflectiveOperationException {
        Class<?> unmodifiableMap = Class.forName("java.util.Collections$UnmodifiableMap");
        Field field = PortSelectorTest.getAccessibleField(unmodifiableMap, "m");
        Object obj = field.get(map);
        ((Map)obj).put(key, value);
    }
}

