/*
 * Decompiled with CFR 0.152.
 */
package org.slinkyframework.environment.docker.test.matchers;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import org.apache.commons.compress.utils.IOUtils;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slinkyframework.environment.builder.EnvironmentBuilderException;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.TimeoutRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

public class HasPortAvailableMatcher
extends TypeSafeMatcher<String> {
    private static final Logger LOG = LoggerFactory.getLogger(HasPortAvailableMatcher.class);
    private static final long THIRTY_SECONDS = 30000L;
    private static final long ONE_SECOND = 1000L;
    private int port;

    public HasPortAvailableMatcher(int port) {
        this.port = port;
    }

    protected boolean matchesSafely(String host) {
        this.waitForPortToStart(host, this.port);
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("Port '" + this.port + "' exists");
    }

    private void waitForPortToStart(String host, int port) {
        TimeoutRetryPolicy retryPolicy = new TimeoutRetryPolicy();
        retryPolicy.setTimeout(30000L);
        FixedBackOffPolicy backOffPolicy = new FixedBackOffPolicy();
        backOffPolicy.setBackOffPeriod(1000L);
        RetryTemplate retryTemplate = new RetryTemplate();
        retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
        retryTemplate.setThrowLastExceptionOnExhausted(true);
        retryTemplate.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        retryTemplate.execute(rc -> this.portInUse(host, port));
    }

    private boolean portInUse(String host, int port) {
        LOG.debug("Check whether {}:{} is in use", (Object)host, (Object)port);
        Socket s = null;
        try {
            s = new Socket(host, port);
            LOG.debug("{}:{} is in use", (Object)host, (Object)port);
        }
        catch (IOException e) {
            try {
                LOG.debug("{}:{} is not in use", (Object)host, (Object)port);
                throw new EnvironmentBuilderException(String.format("Container not available at %s:%s", host, port), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(s);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)s);
        return true;
    }

    public static HasPortAvailableMatcher hasPortAvailable(int port) {
        return new HasPortAvailableMatcher(port);
    }
}

