/*
 * Decompiled with CFR 0.152.
 */
package org.slinkyframework.environment.docker;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Optional;
import org.slinkyframework.environment.builder.EnvironmentBuilderException;

public class PortSelector {
    private static final String ENVIRONMENT_DOCKER_PORT = "ENV_DOCKER_PORT_%s";

    public static int selectFreePort() {
        try {
            ServerSocket s = new ServerSocket(0);
            return s.getLocalPort();
        }
        catch (IOException e) {
            throw new EnvironmentBuilderException("Unable to find a free port", (Throwable)e);
        }
    }

    public static int selectPort(int internalPort) {
        int externalPort = internalPort;
        Optional<String> specifiedPort = PortSelector.getPortFromEnvironment(internalPort);
        if (specifiedPort.isPresent()) {
            externalPort = specifiedPort.get().trim().equals("") ? PortSelector.selectFreePort() : Integer.parseInt(specifiedPort.get());
        }
        return externalPort;
    }

    private static Optional<String> getPortFromEnvironment(int internalPort) {
        return Optional.ofNullable(System.getenv(PortSelector.determineEnvironmentVariable(internalPort)));
    }

    private static String determineEnvironmentVariable(int internalPort) {
        return String.format(ENVIRONMENT_DOCKER_PORT, internalPort);
    }
}

