/*
 * Decompiled with CFR 0.152.
 */
package org.slinkyframework.environment.builder.definition;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slinkyframework.environment.builder.definition.BuildDefinition;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackages={"environment"})
public class BuildDefinitionCollector {
    private static final boolean ALLOW_EAGER_INIT = true;
    private static final boolean INCLUDE_NON_SINGLETONS = true;

    public Map<Class, Set<BuildDefinition>> findBuildDefinitions() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{BuildDefinitionCollector.class});
        HashMap<Class, Set<BuildDefinition>> buildDefinitions = new HashMap<Class, Set<BuildDefinition>>();
        Map beansOfType = context.getBeansOfType(BuildDefinition.class, true, true);
        for (String key : beansOfType.keySet()) {
            this.addBuildDefintionToMap(buildDefinitions, (BuildDefinition)beansOfType.get(key));
        }
        return buildDefinitions;
    }

    private void addBuildDefintionToMap(Map<Class, Set<BuildDefinition>> buildDefinitions, BuildDefinition buildDefinition) {
        Class<?> clazz = buildDefinition.getClass();
        if (buildDefinitions.containsKey(clazz)) {
            buildDefinitions.get(clazz).add(buildDefinition);
        } else {
            TreeSet<BuildDefinition> specificBuildDefinitions = new TreeSet<BuildDefinition>();
            specificBuildDefinitions.add(buildDefinition);
            buildDefinitions.put(clazz, specificBuildDefinitions);
        }
    }
}

