/*
 * Decompiled with CFR 0.152.
 */
package org.slinkyframework.application.logging;

import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slinkyframework.common.logging.AbstractLoggingAspect;
import org.slinkyframework.common.logging.domain.LogAfterContext;
import org.slinkyframework.common.logging.domain.LogBeforeContext;
import org.slinkyframework.common.logging.domain.LogExceptionContext;

@Aspect
public class SlinkyApplicationLoggingAspect
extends AbstractLoggingAspect {
    public static final String LOG_BEFORE = "----> %s %s request received %s";
    public static final String LOG_AFTER = "<---- %s %s response returned in [%d] ms. %s";
    public static final String LOG_EXCEPTION = "<---- %s %s exception returned in [%d] ms., exception message [%s]";
    private static final Logger LOGGER = LoggerFactory.getLogger(SlinkyApplicationLoggingAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ SlinkyApplicationLoggingAspect ajc$perSingletonInstance;

    static {
        try {
            SlinkyApplicationLoggingAspect.ajc$perSingletonInstance = new SlinkyApplicationLoggingAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    protected String createLogBeforeMessage(LogBeforeContext context) {
        return String.format(LOG_BEFORE, context.getClassName(), context.getMethodName(), context.getLoggableParameters());
    }

    protected String createLogAfterMessage(LogAfterContext context) {
        return String.format(LOG_AFTER, context.getClassName(), context.getMethodName(), context.getDurationInMs(), context.getLoggableReturn());
    }

    protected String createLogExceptionMessage(LogExceptionContext context) {
        return String.format(LOG_EXCEPTION, context.getClassName(), context.getMethodName(), context.getDurationInMs(), context.getException().getMessage());
    }

    @Around(value="org.slinkyframework.application.SlinkyApplicationArchitecture.applicationOperations()")
    public Object loggingAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return super.loggingAdvice(proceedingJoinPoint);
    }

    public static SlinkyApplicationLoggingAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.slinkyframework.application.logging.SlinkyApplicationLoggingAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

