/*
 * Decompiled with CFR 0.152.
 */
package org.slinkyframework.client.logging;

import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slinkyframework.common.logging.AbstractLoggingAspect;
import org.slinkyframework.common.logging.domain.LogAfterContext;
import org.slinkyframework.common.logging.domain.LogBeforeContext;
import org.slinkyframework.common.logging.domain.LogExceptionContext;

@Aspect
public class SlinkyClientLoggingAspect
extends AbstractLoggingAspect {
    public static final String LOG_BEFORE = "------> %s %s request sent %s";
    public static final String LOG_AFTER = "<------ %s %s response received in [%d] ms. %s";
    public static final String LOG_EXCEPTION = "<------ %s %s exception received in [%d] ms., exception message [%s]";
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ SlinkyClientLoggingAspect ajc$perSingletonInstance;

    protected String createLogBeforeMessage(LogBeforeContext context) {
        return String.format(LOG_BEFORE, context.getClassName(), context.getMethodName(), context.getLoggableParameters());
    }

    protected String createLogAfterMessage(LogAfterContext context) {
        return String.format(LOG_AFTER, context.getClassName(), context.getMethodName(), context.getDurationInMs(), context.getLoggableReturn());
    }

    protected String createLogExceptionMessage(LogExceptionContext context) {
        return String.format(LOG_EXCEPTION, context.getClassName(), context.getMethodName(), context.getDurationInMs(), context.getException().getMessage());
    }

    @Around(value="org.slinkyframework.client.SlinkyClientArchitecture.clientOperations()")
    public Object loggingAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return super.loggingAdvice(proceedingJoinPoint);
    }

    public static SlinkyClientLoggingAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.slinkyframework.client.logging.SlinkyClientLoggingAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            SlinkyClientLoggingAspect.ajc$perSingletonInstance = new SlinkyClientLoggingAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

