/*
 * Decompiled with CFR 0.152.
 */
package org.slinkyframework.common.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slinkyframework.common.aop.MethodProceedingJoinPoint;

public abstract class AbstractMetricsAspect {
    public static final String METRICS_REGISTRY_NAME = "slinky-metrics";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMetricsAspect.class);
    private static final MetricRegistry metrics = SharedMetricRegistries.getOrCreate((String)"slinky-metrics");
    private final Map<String, Timer> timers = Collections.synchronizedMap(new HashMap());

    protected abstract String getComponentType();

    public Object metricsAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        MethodProceedingJoinPoint methodProceedingJoinPoint = new MethodProceedingJoinPoint(proceedingJoinPoint);
        Timer timer = this.getTimer(methodProceedingJoinPoint);
        Timer.Context context = timer.time();
        try {
            Object object = proceedingJoinPoint.proceed();
            return object;
        }
        finally {
            context.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timer getTimer(MethodProceedingJoinPoint methodProceedingJoinPoint) {
        Map<String, Timer> map = this.timers;
        synchronized (map) {
            String key = this.createKey(methodProceedingJoinPoint);
            if (!this.timers.containsKey(key)) {
                Timer timer = metrics.timer(this.createMetricName(methodProceedingJoinPoint));
                this.timers.put(key, timer);
                LOGGER.debug("Created timer with key {}", (Object)key);
            }
            return this.timers.get(key);
        }
    }

    private String createKey(MethodProceedingJoinPoint methodProceedingJoinPoint) {
        return String.format("%s.%s.%s", this.getComponentType(), methodProceedingJoinPoint.getClassName(), methodProceedingJoinPoint.getMethodName());
    }

    private String createMetricName(MethodProceedingJoinPoint methodProceedingJoinPoint) {
        return MetricRegistry.name((String)this.getComponentType(), (String[])new String[]{methodProceedingJoinPoint.getClassName(), methodProceedingJoinPoint.getMethodName()});
    }
}

