/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import java.util.Set;
import org.jf.baksmali.Adaptors.AnnotationFormatter;
import org.jf.baksmali.Adaptors.EncodedValue.EncodedValueAdaptor;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.util.EncodedValueUtils;
import org.jf.util.IndentingWriter;

public class FieldDefinition {
    public static void writeTo(IndentingWriter writer, Field field, boolean setInStaticConstructor) throws IOException {
        EncodedValue initialValue = field.getInitialValue();
        int accessFlags = field.getAccessFlags();
        if (setInStaticConstructor && AccessFlags.STATIC.isSet(accessFlags) && AccessFlags.FINAL.isSet(accessFlags) && initialValue != null) {
            if (!EncodedValueUtils.isDefaultValue((EncodedValue)initialValue)) {
                writer.write("# The value of this static final field might be set in the static constructor\n");
            } else {
                initialValue = null;
            }
        }
        writer.write(".field ");
        FieldDefinition.writeAccessFlags(writer, field.getAccessFlags());
        writer.write(field.getName());
        writer.write(58);
        writer.write(field.getType());
        if (initialValue != null) {
            writer.write(" = ");
            EncodedValueAdaptor.writeTo(writer, initialValue);
        }
        writer.write(10);
        Set annotations = field.getAnnotations();
        if (annotations.size() > 0) {
            writer.indent(4);
            AnnotationFormatter.writeTo(writer, annotations);
            writer.deindent(4);
            writer.write(".end field\n");
        }
    }

    private static void writeAccessFlags(IndentingWriter writer, int accessFlags) throws IOException {
        for (AccessFlags accessFlag : AccessFlags.getAccessFlagsForField((int)accessFlags)) {
            writer.write(accessFlag.toString());
            writer.write(32);
        }
    }
}

