/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.Renderers.IntegerRenderer;
import org.jf.dexlib2.iface.instruction.SwitchElement;
import org.jf.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import org.jf.util.IndentingWriter;

public class SparseSwitchMethodItem
extends InstructionMethodItem<SparseSwitchPayload> {
    private final List<SparseSwitchTarget> targets;

    public SparseSwitchMethodItem(MethodDefinition methodDef, int codeAddress, SparseSwitchPayload instruction) {
        super(methodDef, codeAddress, instruction);
        int baseCodeAddress = methodDef.getSparseSwitchBaseAddress(codeAddress);
        this.targets = new ArrayList<SparseSwitchTarget>();
        if (baseCodeAddress >= 0) {
            for (SwitchElement switchElement : instruction.getSwitchElements()) {
                LabelMethodItem label = methodDef.getLabelCache().internLabel(new LabelMethodItem(methodDef.classDef.options, baseCodeAddress + switchElement.getOffset(), "sswitch_"));
                this.targets.add(new SparseSwitchLabelTarget(switchElement.getKey(), label));
            }
        } else {
            for (SwitchElement switchElement : instruction.getSwitchElements()) {
                this.targets.add(new SparseSwitchOffsetTarget(switchElement.getKey(), switchElement.getOffset()));
            }
        }
    }

    @Override
    public boolean writeTo(IndentingWriter writer) throws IOException {
        writer.write(".sparse-switch\n");
        writer.indent(4);
        for (SparseSwitchTarget target : this.targets) {
            IntegerRenderer.writeTo(writer, target.getKey());
            writer.write(" -> ");
            target.writeTargetTo(writer);
            this.writeResourceId(writer, target.getKey());
            writer.write(10);
        }
        writer.deindent(4);
        writer.write(".end sparse-switch");
        return true;
    }

    private static class SparseSwitchOffsetTarget
    extends SparseSwitchTarget {
        private final int target;

        public SparseSwitchOffsetTarget(int key, int target) {
            super(key);
            this.target = target;
        }

        @Override
        public void writeTargetTo(IndentingWriter writer) throws IOException {
            if (this.target >= 0) {
                writer.write(43);
            }
            writer.printSignedIntAsDec(this.target);
        }
    }

    private static class SparseSwitchLabelTarget
    extends SparseSwitchTarget {
        private final LabelMethodItem target;

        public SparseSwitchLabelTarget(int key, LabelMethodItem target) {
            super(key);
            this.target = target;
        }

        @Override
        public void writeTargetTo(IndentingWriter writer) throws IOException {
            this.target.writeTo(writer);
        }
    }

    private static abstract class SparseSwitchTarget {
        private final int key;

        public SparseSwitchTarget(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public abstract void writeTargetTo(IndentingWriter var1) throws IOException;
    }
}

