/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jf.baksmali.baksmali;
import org.jf.baksmali.baksmaliOptions;
import org.jf.baksmali.dump;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.analysis.CustomInlineMethodResolver;
import org.jf.dexlib2.analysis.InlineMethodResolver;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedOdexFile;
import org.jf.dexlib2.iface.DexFile;
import org.jf.util.ConsoleUtil;
import org.jf.util.SmaliHelpFormatter;

public class main {
    public static final String VERSION;
    private static final Options basicOptions;
    private static final Options debugOptions;
    private static final Options options;

    private main() {
    }

    public static void main(String[] args) throws IOException {
        DexBackedDexFile dexFile;
        String inputDexFileName;
        File dexFileFile;
        CommandLine commandLine;
        Locale locale = new Locale("en", "US");
        Locale.setDefault(locale);
        PosixParser parser = new PosixParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException ex) {
            main.usage();
            return;
        }
        baksmaliOptions options = new baksmaliOptions();
        boolean disassemble = true;
        boolean doDump = false;
        String dumpFileName = null;
        boolean setBootClassPath = false;
        String[] remainingArgs = commandLine.getArgs();
        Option[] clOptions = commandLine.getOptions();
        block24: for (int i = 0; i < clOptions.length; ++i) {
            Option option = clOptions[i];
            String opt = option.getOpt();
            switch (opt.charAt(0)) {
                case 'v': {
                    main.version();
                    return;
                }
                case '?': {
                    while (++i < clOptions.length) {
                        if (clOptions[i].getOpt().charAt(0) != '?') continue;
                        main.usage(true);
                        return;
                    }
                    main.usage(false);
                    return;
                }
                case 'o': {
                    options.outputDirectory = commandLine.getOptionValue("o");
                    continue block24;
                }
                case 'p': {
                    options.noParameterRegisters = true;
                    continue block24;
                }
                case 'l': {
                    options.useLocalsDirective = true;
                    continue block24;
                }
                case 's': {
                    options.useSequentialLabels = true;
                    continue block24;
                }
                case 'b': {
                    options.outputDebugInfo = false;
                    continue block24;
                }
                case 'd': {
                    options.bootClassPathDirs.add(option.getValue());
                    continue block24;
                }
                case 'f': {
                    options.addCodeOffsets = true;
                    continue block24;
                }
                case 'r': {
                    String[] values = commandLine.getOptionValues('r');
                    int registerInfo = 0;
                    if (values == null || values.length == 0) {
                        registerInfo = 24;
                    } else {
                        for (String value : values) {
                            if (value.equalsIgnoreCase("ALL")) {
                                registerInfo |= 1;
                                continue;
                            }
                            if (value.equalsIgnoreCase("ALLPRE")) {
                                registerInfo |= 2;
                                continue;
                            }
                            if (value.equalsIgnoreCase("ALLPOST")) {
                                registerInfo |= 4;
                                continue;
                            }
                            if (value.equalsIgnoreCase("ARGS")) {
                                registerInfo |= 8;
                                continue;
                            }
                            if (value.equalsIgnoreCase("DEST")) {
                                registerInfo |= 0x10;
                                continue;
                            }
                            if (value.equalsIgnoreCase("MERGE")) {
                                registerInfo |= 0x20;
                                continue;
                            }
                            if (value.equalsIgnoreCase("FULLMERGE")) {
                                registerInfo |= 0x40;
                                continue;
                            }
                            main.usage();
                            return;
                        }
                        if ((registerInfo & 0x40) != 0) {
                            registerInfo &= 0xFFFFFFDF;
                        }
                    }
                    options.registerInfo = registerInfo;
                    continue block24;
                }
                case 'c': {
                    String bcp = commandLine.getOptionValue("c");
                    if (bcp != null && bcp.charAt(0) == ':') {
                        options.addExtraClassPath(bcp);
                        continue block24;
                    }
                    setBootClassPath = true;
                    options.setBootClassPath(bcp);
                    continue block24;
                }
                case 'x': {
                    options.deodex = true;
                    continue block24;
                }
                case 'm': {
                    options.noAccessorComments = true;
                    continue block24;
                }
                case 'a': {
                    options.apiLevel = Integer.parseInt(commandLine.getOptionValue("a"));
                    continue block24;
                }
                case 'j': {
                    options.jobs = Integer.parseInt(commandLine.getOptionValue("j"));
                    continue block24;
                }
                case 'i': {
                    String rif = commandLine.getOptionValue("i");
                    options.setResourceIdFiles(rif);
                    continue block24;
                }
                case 'N': {
                    disassemble = false;
                    continue block24;
                }
                case 'D': {
                    doDump = true;
                    dumpFileName = commandLine.getOptionValue("D");
                    continue block24;
                }
                case 'I': {
                    options.ignoreErrors = true;
                    continue block24;
                }
                case 'T': {
                    options.inlineResolver = new CustomInlineMethodResolver(options.classPath, new File(commandLine.getOptionValue("T")));
                    continue block24;
                }
                default: {
                    assert (false);
                    continue block24;
                }
            }
        }
        if (remainingArgs.length != 1) {
            main.usage();
            return;
        }
        if (options.jobs <= 0) {
            options.jobs = Runtime.getRuntime().availableProcessors();
            if (options.jobs > 6) {
                options.jobs = 6;
            }
        }
        if (options.apiLevel >= 17) {
            options.checkPackagePrivateAccess = true;
        }
        if (!(dexFileFile = new File(inputDexFileName = remainingArgs[0])).exists()) {
            System.err.println("Can't find the file " + inputDexFileName);
            System.exit(1);
        }
        if ((dexFile = DexFileFactory.loadDexFile((File)dexFileFile, (int)options.apiLevel)).isOdexFile()) {
            if (!options.deodex) {
                System.err.println("Warning: You are disassembling an odex file without deodexing it. You");
                System.err.println("won't be able to re-assemble the results unless you deodex it with the -x");
                System.err.println("option");
                options.allowOdex = true;
            }
        } else {
            options.deodex = false;
        }
        if (!setBootClassPath && (options.deodex || options.registerInfo != 0)) {
            options.bootClassPathEntries = dexFile instanceof DexBackedOdexFile ? ((DexBackedOdexFile)dexFile).getDependencies() : main.getDefaultBootClassPathForApi(options.apiLevel);
        }
        if (options.inlineResolver == null && dexFile instanceof DexBackedOdexFile) {
            options.inlineResolver = InlineMethodResolver.createInlineMethodResolver((int)((DexBackedOdexFile)dexFile).getOdexVersion());
        }
        boolean errorOccurred = false;
        if (disassemble) {
            boolean bl = errorOccurred = !baksmali.disassembleDexFile((DexFile)dexFile, options);
        }
        if (doDump) {
            if (dumpFileName == null) {
                dumpFileName = commandLine.getOptionValue(inputDexFileName + ".dump");
            }
            dump.dump(dexFile, dumpFileName, options.apiLevel);
        }
        if (errorOccurred) {
            System.exit(1);
        }
    }

    private static void usage(boolean printDebugOptions) {
        SmaliHelpFormatter formatter = new SmaliHelpFormatter();
        int consoleWidth = ConsoleUtil.getConsoleWidth();
        if (consoleWidth <= 0) {
            consoleWidth = 80;
        }
        formatter.setWidth(consoleWidth);
        formatter.printHelp("java -jar baksmali.jar [options] <dex-file>", "disassembles and/or dumps a dex file", basicOptions, (Options)(printDebugOptions ? debugOptions : null));
    }

    private static void usage() {
        main.usage(false);
    }

    protected static void version() {
        System.out.println("baksmali " + VERSION + " (http://smali.googlecode.com)");
        System.out.println("Copyright (C) 2010 Ben Gruver (JesusFreke@JesusFreke.com)");
        System.out.println("BSD license (http://www.opensource.org/licenses/bsd-license.php)");
        System.exit(0);
    }

    private static void buildOptions() {
        OptionBuilder.withLongOpt((String)"version");
        OptionBuilder.withDescription((String)"prints the version then exits");
        Option versionOption = OptionBuilder.create((String)"v");
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"prints the help message then exits. Specify twice for debug options");
        Option helpOption = OptionBuilder.create((String)"?");
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.withDescription((String)"the directory where the disassembled files will be placed. The default is out");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"DIR");
        Option outputDirOption = OptionBuilder.create((String)"o");
        OptionBuilder.withLongOpt((String)"no-parameter-registers");
        OptionBuilder.withDescription((String)"use the v<n> syntax instead of the p<n> syntax for registers mapped to method parameters");
        Option noParameterRegistersOption = OptionBuilder.create((String)"p");
        OptionBuilder.withLongOpt((String)"deodex");
        OptionBuilder.withDescription((String)"deodex the given odex file. This option is ignored if the input file is not an odex file");
        Option deodexerantOption = OptionBuilder.create((String)"x");
        OptionBuilder.withLongOpt((String)"use-locals");
        OptionBuilder.withDescription((String)"output the .locals directive with the number of non-parameter registers, rather than the .register directive with the total number of register");
        Option useLocalsOption = OptionBuilder.create((String)"l");
        OptionBuilder.withLongOpt((String)"sequential-labels");
        OptionBuilder.withDescription((String)"create label names using a sequential numbering scheme per label type, rather than using the bytecode address");
        Option sequentialLabelsOption = OptionBuilder.create((String)"s");
        OptionBuilder.withLongOpt((String)"no-debug-info");
        OptionBuilder.withDescription((String)"don't write out debug info (.local, .param, .line, etc.)");
        Option noDebugInfoOption = OptionBuilder.create((String)"b");
        OptionBuilder.withLongOpt((String)"register-info");
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withArgName((String)"REGISTER_INFO_TYPES");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.withDescription((String)"print the specificed type(s) of register information for each instruction. \"ARGS,DEST\" is the default if no types are specified.\nValid values are:\nALL: all pre- and post-instruction registers.\nALLPRE: all pre-instruction registers\nALLPOST: all post-instruction registers\nARGS: any pre-instruction registers used as arguments to the instruction\nDEST: the post-instruction destination register, if any\nMERGE: Any pre-instruction register has been merged from more than 1 different post-instruction register from its predecessors\nFULLMERGE: For each register that would be printed by MERGE, also show the incoming register types that were merged");
        Option registerInfoOption = OptionBuilder.create((String)"r");
        OptionBuilder.withLongOpt((String)"bootclasspath");
        OptionBuilder.withDescription((String)"the bootclasspath jars to use, for analysis. Defaults to core.jar:ext.jar:framework.jar:android.policy.jar:services.jar. If the value begins with a :, it will be appended to the default bootclasspath instead of replacing it");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)"BOOTCLASSPATH");
        Option classPathOption = OptionBuilder.create((String)"c");
        OptionBuilder.withLongOpt((String)"bootclasspath-dir");
        OptionBuilder.withDescription((String)"the base folder to look for the bootclasspath files in. Defaults to the current directory");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"DIR");
        Option classPathDirOption = OptionBuilder.create((String)"d");
        OptionBuilder.withLongOpt((String)"code-offsets");
        OptionBuilder.withDescription((String)"add comments to the disassembly containing the code offset for each address");
        Option codeOffsetOption = OptionBuilder.create((String)"f");
        OptionBuilder.withLongOpt((String)"no-accessor-comments");
        OptionBuilder.withDescription((String)"don't output helper comments for synthetic accessors");
        Option noAccessorCommentsOption = OptionBuilder.create((String)"m");
        OptionBuilder.withLongOpt((String)"api-level");
        OptionBuilder.withDescription((String)"The numeric api-level of the file being disassembled. If not specified, it defaults to 15 (ICS).");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"API_LEVEL");
        Option apiLevelOption = OptionBuilder.create((String)"a");
        OptionBuilder.withLongOpt((String)"jobs");
        OptionBuilder.withDescription((String)"The number of threads to use. Defaults to the number of cores available, up to a maximum of 6");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"NUM_THREADS");
        Option jobsOption = OptionBuilder.create((String)"j");
        OptionBuilder.withLongOpt((String)"resource-id-files");
        OptionBuilder.withDescription((String)"the resource ID files to use, for analysis. A colon-separated list of prefix=file pairs.  For example R=res/values/public.xml:android.R=$ANDROID_HOME/platforms/android-19/data/res/values/public.xml");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FILES");
        Option resourceIdFilesOption = OptionBuilder.create((String)"i");
        OptionBuilder.withLongOpt((String)"dump-to");
        OptionBuilder.withDescription((String)"dumps the given dex file into a single annotated dump file named FILE (<dexfile>.dump by default), along with the normal disassembly");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)"FILE");
        Option dumpOption = OptionBuilder.create((String)"D");
        OptionBuilder.withLongOpt((String)"ignore-errors");
        OptionBuilder.withDescription((String)"ignores any non-fatal errors that occur while disassembling/deodexing, ignoring the class if needed, and continuing with the next class. The default behavior is to stop disassembling and exit once an error is encountered");
        Option ignoreErrorsOption = OptionBuilder.create((String)"I");
        OptionBuilder.withLongOpt((String)"no-disassembly");
        OptionBuilder.withDescription((String)"suppresses the output of the disassembly");
        Option noDisassemblyOption = OptionBuilder.create((String)"N");
        OptionBuilder.withLongOpt((String)"inline-table");
        OptionBuilder.withDescription((String)"specify a file containing a custom inline method table to use for deodexing");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FILE");
        Option inlineTableOption = OptionBuilder.create((String)"T");
        basicOptions.addOption(versionOption);
        basicOptions.addOption(helpOption);
        basicOptions.addOption(outputDirOption);
        basicOptions.addOption(noParameterRegistersOption);
        basicOptions.addOption(deodexerantOption);
        basicOptions.addOption(useLocalsOption);
        basicOptions.addOption(sequentialLabelsOption);
        basicOptions.addOption(noDebugInfoOption);
        basicOptions.addOption(registerInfoOption);
        basicOptions.addOption(classPathOption);
        basicOptions.addOption(classPathDirOption);
        basicOptions.addOption(codeOffsetOption);
        basicOptions.addOption(noAccessorCommentsOption);
        basicOptions.addOption(apiLevelOption);
        basicOptions.addOption(jobsOption);
        basicOptions.addOption(resourceIdFilesOption);
        debugOptions.addOption(dumpOption);
        debugOptions.addOption(ignoreErrorsOption);
        debugOptions.addOption(noDisassemblyOption);
        debugOptions.addOption(inlineTableOption);
        for (Object option : basicOptions.getOptions()) {
            options.addOption((Option)option);
        }
        for (Object option : debugOptions.getOptions()) {
            options.addOption((Option)option);
        }
    }

    @Nonnull
    private static List<String> getDefaultBootClassPathForApi(int apiLevel) {
        if (apiLevel < 9) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar"});
        }
        if (apiLevel < 12) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/core-junit.jar"});
        }
        if (apiLevel < 14) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/apache-xml.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/core-junit.jar"});
        }
        if (apiLevel < 16) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/apache-xml.jar", "/system/framework/filterfw.jar"});
        }
        return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/telephony-common.jar", "/system/framework/mms-common.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/apache-xml.jar"});
    }

    static {
        options = new Options();
        basicOptions = new Options();
        debugOptions = new Options();
        main.buildOptions();
        InputStream templateStream = baksmali.class.getClassLoader().getResourceAsStream("baksmali.properties");
        if (templateStream != null) {
            Properties properties = new Properties();
            String version = "(unknown)";
            try {
                properties.load(templateStream);
                version = properties.getProperty("application.version");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            VERSION = version;
        } else {
            VERSION = "[unknown version]";
        }
    }
}

