/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Renderers.LongRenderer;
import org.jf.baksmali.baksmaliOptions;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.ReferenceType;
import org.jf.dexlib2.VerificationError;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.instruction.FieldOffsetInstruction;
import org.jf.dexlib2.iface.instruction.FiveRegisterInstruction;
import org.jf.dexlib2.iface.instruction.InlineIndexInstruction;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.NarrowLiteralInstruction;
import org.jf.dexlib2.iface.instruction.OneRegisterInstruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.RegisterRangeInstruction;
import org.jf.dexlib2.iface.instruction.ThreeRegisterInstruction;
import org.jf.dexlib2.iface.instruction.TwoRegisterInstruction;
import org.jf.dexlib2.iface.instruction.VtableIndexInstruction;
import org.jf.dexlib2.iface.instruction.WideLiteralInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction20bc;
import org.jf.dexlib2.iface.instruction.formats.Instruction31t;
import org.jf.dexlib2.iface.instruction.formats.UnknownInstruction;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.util.ExceptionWithContext;
import org.jf.util.IndentingWriter;
import org.jf.util.NumberUtils;

public class InstructionMethodItem<T extends Instruction>
extends MethodItem {
    @Nonnull
    protected final MethodDefinition methodDef;
    @Nonnull
    protected final T instruction;

    public InstructionMethodItem(@Nonnull MethodDefinition methodDef, int codeAddress, @Nonnull T instruction) {
        super(codeAddress);
        this.methodDef = methodDef;
        this.instruction = instruction;
    }

    @Override
    public double getSortOrder() {
        return 100.0;
    }

    private boolean isAllowedOdex(@Nonnull Opcode opcode) {
        baksmaliOptions options = this.methodDef.classDef.options;
        if (options.allowOdex) {
            return true;
        }
        if (this.methodDef.classDef.options.apiLevel >= 14) {
            return false;
        }
        return opcode.isOdexedInstanceVolatile() || opcode.isOdexedStaticVolatile() || opcode == Opcode.THROW_VERIFICATION_ERROR;
    }

    @Override
    public boolean writeTo(IndentingWriter writer) throws IOException {
        int verificationError;
        Opcode opcode = this.instruction.getOpcode();
        String verificationErrorName = null;
        String referenceString = null;
        boolean commentOutInstruction = false;
        if (this.instruction instanceof Instruction20bc && (verificationErrorName = VerificationError.getVerificationErrorName((int)(verificationError = ((Instruction20bc)this.instruction).getVerificationError()))) == null) {
            writer.write("#was invalid verification error type: ");
            writer.printSignedIntAsDec(verificationError);
            writer.write("\n");
            verificationErrorName = "generic-error";
        }
        if (this.instruction instanceof ReferenceInstruction) {
            ReferenceInstruction referenceInstruction = (ReferenceInstruction)this.instruction;
            try {
                Reference reference = referenceInstruction.getReference();
                String classContext = null;
                if (this.methodDef.classDef.options.useImplicitReferences) {
                    classContext = this.methodDef.method.getDefiningClass();
                }
                referenceString = ReferenceUtil.getReferenceString((Reference)reference, classContext);
                assert (referenceString != null);
            }
            catch (DexBackedDexFile.InvalidItemIndex ex) {
                writer.write("#");
                writer.write(ex.getMessage());
                writer.write("\n");
                commentOutInstruction = true;
                referenceString = String.format("%s@%d", ReferenceType.toString((int)referenceInstruction.getReferenceType()), ex.getInvalidIndex());
            }
            catch (ReferenceType.InvalidReferenceTypeException ex) {
                writer.write("#invalid reference type: ");
                writer.printSignedIntAsDec(ex.getReferenceType());
                commentOutInstruction = true;
                referenceString = "invalid_reference";
            }
        }
        if (this.instruction instanceof Instruction31t) {
            Opcode payloadOpcode;
            switch (this.instruction.getOpcode()) {
                case PACKED_SWITCH: {
                    payloadOpcode = Opcode.PACKED_SWITCH_PAYLOAD;
                    break;
                }
                case SPARSE_SWITCH: {
                    payloadOpcode = Opcode.SPARSE_SWITCH_PAYLOAD;
                    break;
                }
                case FILL_ARRAY_DATA: {
                    payloadOpcode = Opcode.ARRAY_PAYLOAD;
                    break;
                }
                default: {
                    throw new ExceptionWithContext("Invalid 31t opcode: %s", new Object[]{this.instruction.getOpcode()});
                }
            }
            try {
                this.methodDef.findSwitchPayload(this.codeAddress + ((Instruction31t)this.instruction).getCodeOffset(), payloadOpcode);
            }
            catch (MethodDefinition.InvalidSwitchPayload ex) {
                writer.write("#invalid payload reference");
                commentOutInstruction = true;
            }
        }
        if (opcode.odexOnly() && !this.isAllowedOdex(opcode)) {
            writer.write("#disallowed odex opcode\n");
            commentOutInstruction = true;
        }
        if (commentOutInstruction) {
            writer.write("#");
        }
        switch (this.instruction.getOpcode().format) {
            case Format10t: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeTargetLabel(writer);
                break;
            }
            case Format10x: {
                if (this.instruction instanceof UnknownInstruction) {
                    writer.write("#unknown opcode: 0x");
                    writer.printUnsignedLongAsHex((long)((UnknownInstruction)this.instruction).getOriginalOpcode());
                    writer.write(10);
                }
                this.writeOpcode(writer);
                break;
            }
            case Format11n: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeLiteral(writer);
                break;
            }
            case Format11x: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                break;
            }
            case Format12x: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                break;
            }
            case Format20bc: {
                this.writeOpcode(writer);
                writer.write(32);
                writer.write(verificationErrorName);
                writer.write(", ");
                writer.write(referenceString);
                break;
            }
            case Format20t: 
            case Format30t: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeTargetLabel(writer);
                break;
            }
            case Format21c: 
            case Format31c: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                writer.write(referenceString);
                break;
            }
            case Format21ih: 
            case Format21lh: 
            case Format21s: 
            case Format31i: 
            case Format51l: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeLiteral(writer);
                if (this.instruction.getOpcode().setsWideRegister()) {
                    this.writeCommentIfLikelyDouble(writer);
                    break;
                }
                boolean isResourceId = this.writeCommentIfResourceId(writer);
                if (isResourceId) break;
                this.writeCommentIfLikelyFloat(writer);
                break;
            }
            case Format21t: 
            case Format31t: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeTargetLabel(writer);
                break;
            }
            case Format22b: 
            case Format22s: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                writer.write(", ");
                this.writeLiteral(writer);
                break;
            }
            case Format22c: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                writer.write(", ");
                writer.write(referenceString);
                break;
            }
            case Format22cs: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                writer.write(", ");
                this.writeFieldOffset(writer);
                break;
            }
            case Format22t: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                writer.write(", ");
                this.writeTargetLabel(writer);
                break;
            }
            case Format22x: 
            case Format32x: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                break;
            }
            case Format23x: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeFirstRegister(writer);
                writer.write(", ");
                this.writeSecondRegister(writer);
                writer.write(", ");
                this.writeThirdRegister(writer);
                break;
            }
            case Format35c: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeInvokeRegisters(writer);
                writer.write(", ");
                writer.write(referenceString);
                break;
            }
            case Format35mi: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeInvokeRegisters(writer);
                writer.write(", ");
                this.writeInlineIndex(writer);
                break;
            }
            case Format35ms: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeInvokeRegisters(writer);
                writer.write(", ");
                this.writeVtableIndex(writer);
                break;
            }
            case Format3rc: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeInvokeRangeRegisters(writer);
                writer.write(", ");
                writer.write(referenceString);
                break;
            }
            case Format3rmi: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeInvokeRangeRegisters(writer);
                writer.write(", ");
                this.writeInlineIndex(writer);
                break;
            }
            case Format3rms: {
                this.writeOpcode(writer);
                writer.write(32);
                this.writeInvokeRangeRegisters(writer);
                writer.write(", ");
                this.writeVtableIndex(writer);
                break;
            }
            default: {
                assert (false);
                return false;
            }
        }
        if (commentOutInstruction) {
            writer.write("\nnop");
        }
        return true;
    }

    protected void writeOpcode(IndentingWriter writer) throws IOException {
        writer.write(this.instruction.getOpcode().name);
    }

    protected void writeTargetLabel(IndentingWriter writer) throws IOException {
        throw new RuntimeException();
    }

    protected void writeRegister(IndentingWriter writer, int registerNumber) throws IOException {
        this.methodDef.registerFormatter.writeTo(writer, registerNumber);
    }

    protected void writeFirstRegister(IndentingWriter writer) throws IOException {
        this.writeRegister(writer, ((OneRegisterInstruction)this.instruction).getRegisterA());
    }

    protected void writeSecondRegister(IndentingWriter writer) throws IOException {
        this.writeRegister(writer, ((TwoRegisterInstruction)this.instruction).getRegisterB());
    }

    protected void writeThirdRegister(IndentingWriter writer) throws IOException {
        this.writeRegister(writer, ((ThreeRegisterInstruction)this.instruction).getRegisterC());
    }

    protected void writeInvokeRegisters(IndentingWriter writer) throws IOException {
        FiveRegisterInstruction instruction = (FiveRegisterInstruction)this.instruction;
        int regCount = instruction.getRegisterCount();
        writer.write(123);
        switch (regCount) {
            case 1: {
                this.writeRegister(writer, instruction.getRegisterC());
                break;
            }
            case 2: {
                this.writeRegister(writer, instruction.getRegisterC());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterD());
                break;
            }
            case 3: {
                this.writeRegister(writer, instruction.getRegisterC());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterD());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterE());
                break;
            }
            case 4: {
                this.writeRegister(writer, instruction.getRegisterC());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterD());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterE());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterF());
                break;
            }
            case 5: {
                this.writeRegister(writer, instruction.getRegisterC());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterD());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterE());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterF());
                writer.write(", ");
                this.writeRegister(writer, instruction.getRegisterG());
            }
        }
        writer.write(125);
    }

    protected void writeInvokeRangeRegisters(IndentingWriter writer) throws IOException {
        RegisterRangeInstruction instruction = (RegisterRangeInstruction)this.instruction;
        int regCount = instruction.getRegisterCount();
        if (regCount == 0) {
            writer.write("{}");
        } else {
            int startRegister = instruction.getStartRegister();
            this.methodDef.registerFormatter.writeRegisterRange(writer, startRegister, startRegister + regCount - 1);
        }
    }

    protected void writeLiteral(IndentingWriter writer) throws IOException {
        LongRenderer.writeSignedIntOrLongTo(writer, ((WideLiteralInstruction)this.instruction).getWideLiteral());
    }

    protected void writeCommentIfLikelyFloat(IndentingWriter writer) throws IOException {
        this.writeCommentIfLikelyFloat(writer, ((NarrowLiteralInstruction)this.instruction).getNarrowLiteral());
    }

    protected void writeCommentIfLikelyFloat(IndentingWriter writer, int val) throws IOException {
        if (NumberUtils.isLikelyFloat((int)val)) {
            writer.write("    # ");
            float fval = Float.intBitsToFloat(val);
            if (fval == Float.POSITIVE_INFINITY) {
                writer.write("Float.POSITIVE_INFINITY");
            } else if (fval == Float.NEGATIVE_INFINITY) {
                writer.write("Float.NEGATIVE_INFINITY");
            } else if (fval == Float.NaN) {
                writer.write("Float.NaN");
            } else if (fval == Float.MAX_VALUE) {
                writer.write("Float.MAX_VALUE");
            } else if (fval == (float)Math.PI) {
                writer.write("(float)Math.PI");
            } else if (fval == (float)Math.E) {
                writer.write("(float)Math.E");
            } else {
                writer.write(Float.toString(fval));
                writer.write(102);
            }
        }
    }

    protected void writeCommentIfLikelyDouble(IndentingWriter writer) throws IOException {
        this.writeCommentIfLikelyDouble(writer, ((WideLiteralInstruction)this.instruction).getWideLiteral());
    }

    protected void writeCommentIfLikelyDouble(IndentingWriter writer, long val) throws IOException {
        if (NumberUtils.isLikelyDouble((long)val)) {
            writer.write("    # ");
            double dval = Double.longBitsToDouble(val);
            if (dval == Double.POSITIVE_INFINITY) {
                writer.write("Double.POSITIVE_INFINITY");
            } else if (dval == Double.NEGATIVE_INFINITY) {
                writer.write("Double.NEGATIVE_INFINITY");
            } else if (dval == Double.NaN) {
                writer.write("Double.NaN");
            } else if (dval == Double.MAX_VALUE) {
                writer.write("Double.MAX_VALUE");
            } else if (dval == Math.PI) {
                writer.write("Math.PI");
            } else if (dval == Math.E) {
                writer.write("Math.E");
            } else {
                writer.write(Double.toString(dval));
            }
        }
    }

    protected boolean writeCommentIfResourceId(IndentingWriter writer) throws IOException {
        return this.writeCommentIfResourceId(writer, ((NarrowLiteralInstruction)this.instruction).getNarrowLiteral());
    }

    protected boolean writeCommentIfResourceId(IndentingWriter writer, int val) throws IOException {
        Map<Integer, String> resourceIds = this.methodDef.classDef.options.resourceIds;
        String resource = resourceIds.get(val);
        if (resource != null) {
            writer.write("    # ");
            writer.write(resource);
            return true;
        }
        return false;
    }

    protected void writeFieldOffset(IndentingWriter writer) throws IOException {
        writer.write("field@0x");
        writer.printUnsignedLongAsHex((long)((FieldOffsetInstruction)this.instruction).getFieldOffset());
    }

    protected void writeInlineIndex(IndentingWriter writer) throws IOException {
        writer.write("inline@");
        writer.printSignedIntAsDec(((InlineIndexInstruction)this.instruction).getInlineIndex());
    }

    protected void writeVtableIndex(IndentingWriter writer) throws IOException {
        writer.write("vtable@");
        writer.printSignedIntAsDec(((VtableIndexInstruction)this.instruction).getVtableIndex());
    }
}

