/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.Renderers.IntegerRenderer;
import org.jf.dexlib2.iface.instruction.SwitchElement;
import org.jf.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import org.jf.util.IndentingWriter;

public class PackedSwitchMethodItem
extends InstructionMethodItem<PackedSwitchPayload> {
    private final List<PackedSwitchTarget> targets;
    private final int firstKey;

    public PackedSwitchMethodItem(MethodDefinition methodDef, int codeAddress, PackedSwitchPayload instruction) {
        super(methodDef, codeAddress, instruction);
        int baseCodeAddress = methodDef.getPackedSwitchBaseAddress(codeAddress);
        this.targets = new ArrayList<PackedSwitchTarget>();
        boolean first = true;
        int firstKey = 0;
        if (baseCodeAddress >= 0) {
            for (SwitchElement switchElement : instruction.getSwitchElements()) {
                if (first) {
                    firstKey = switchElement.getKey();
                    first = false;
                }
                LabelMethodItem label = methodDef.getLabelCache().internLabel(new LabelMethodItem(methodDef.classDef.options, baseCodeAddress + switchElement.getOffset(), "pswitch_"));
                this.targets.add(new PackedSwitchLabelTarget(label));
            }
        } else {
            for (SwitchElement switchElement : instruction.getSwitchElements()) {
                if (first) {
                    firstKey = switchElement.getKey();
                    first = false;
                }
                this.targets.add(new PackedSwitchOffsetTarget(switchElement.getOffset()));
            }
        }
        this.firstKey = firstKey;
    }

    @Override
    public boolean writeTo(IndentingWriter writer) throws IOException {
        writer.write(".packed-switch ");
        IntegerRenderer.writeTo(writer, this.firstKey);
        writer.indent(4);
        writer.write(10);
        int key = this.firstKey;
        for (PackedSwitchTarget target : this.targets) {
            target.writeTargetTo(writer);
            this.writeCommentIfResourceId(writer, key);
            writer.write(10);
            ++key;
        }
        writer.deindent(4);
        writer.write(".end packed-switch");
        return true;
    }

    private static class PackedSwitchOffsetTarget
    extends PackedSwitchTarget {
        private final int target;

        public PackedSwitchOffsetTarget(int target) {
            this.target = target;
        }

        @Override
        public void writeTargetTo(IndentingWriter writer) throws IOException {
            if (this.target >= 0) {
                writer.write(43);
            }
            writer.printSignedIntAsDec(this.target);
        }
    }

    private static class PackedSwitchLabelTarget
    extends PackedSwitchTarget {
        private final LabelMethodItem target;

        public PackedSwitchLabelTarget(LabelMethodItem target) {
            this.target = target;
        }

        @Override
        public void writeTargetTo(IndentingWriter writer) throws IOException {
            this.target.writeTo(writer);
        }
    }

    private static abstract class PackedSwitchTarget {
        private PackedSwitchTarget() {
        }

        public abstract void writeTargetTo(IndentingWriter var1) throws IOException;
    }
}

