/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.util.List;
import javax.annotation.Nonnull;
import org.jf.baksmali.DexInputCommand;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.util.ReferenceUtil;

public abstract class ListReferencesCommand
extends DexInputCommand {
    private final int referenceType;
    @Parameter(names={"-h", "-?", "--help"}, help=true, description="Show usage information")
    private boolean help;

    public ListReferencesCommand(@Nonnull List<JCommander> commandAncestors, int referenceType) {
        super(commandAncestors);
        this.referenceType = referenceType;
    }

    public void run() {
        if (this.help || this.inputList == null || this.inputList.isEmpty()) {
            this.usage();
            return;
        }
        if (this.inputList.size() > 1) {
            System.err.println("Too many files specified");
            this.usage();
            return;
        }
        String input = (String)this.inputList.get(0);
        this.loadDexFile(input, Opcodes.getDefault());
        for (Reference reference : this.dexFile.getReferences(this.referenceType)) {
            System.out.println(ReferenceUtil.getReferenceString((Reference)reference));
        }
    }
}

