/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.promise.impl;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.smallibs.concurrent.promise.Promise;
import org.smallibs.concurrent.promise.PromiseHelper;
import org.smallibs.concurrent.promise.impl.FlatMappedPromise;
import org.smallibs.concurrent.promise.impl.MappedPromise;
import org.smallibs.exception.FilterException;
import org.smallibs.util.FunctionWithError;

abstract class AbstractPromise<T>
implements Promise<T> {
    protected AbstractPromise() {
    }

    @Override
    public final <R> Promise<R> map(FunctionWithError<? super T, ? extends R> function) {
        Objects.requireNonNull(function);
        return new MappedPromise<T, R>(this, function);
    }

    @Override
    public final <R> Promise<R> flatmap(Function<? super T, Promise<R>> function) {
        Objects.requireNonNull(function);
        return new FlatMappedPromise<T, R>(this, function);
    }

    public final Promise<T> filter(Predicate<? super T> predicate) {
        return this.flatmap(t -> {
            if (predicate.test(t)) {
                return PromiseHelper.success(t);
            }
            return PromiseHelper.failure(new FilterException());
        });
    }

    @Override
    public final Promise<T> self() {
        return this;
    }
}

