/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.util;

import java.util.function.Function;
import org.smallibs.data.Try;
import org.smallibs.util.FunctionWithError;

public enum FunctionsHelper {


    public static <A, B, C> Function<A, C> compose(Function<B, C> f, Function<A, B> g) {
        return x -> f.apply(g.apply(x));
    }

    public static <A> Function<A, A> id() {
        return Function.identity();
    }

    public static <T, R> FunctionWithError<T, R> fromFunction(Function<T, R> function) {
        return function::apply;
    }

    public static <T, R> Function<T, Try<R>> toFunction(FunctionWithError<T, R> function) {
        return t -> {
            try {
                return Try.success(function.apply(t));
            }
            catch (Throwable throwable) {
                return Try.failure(throwable);
            }
        };
    }
}

