/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.promise;

import java.time.Duration;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import org.smallibs.concurrent.promise.PromiseHelper;
import org.smallibs.control.Filter;
import org.smallibs.data.Try;
import org.smallibs.type.HK;
import org.smallibs.util.FunctionWithError;

public interface Promise<T>
extends Filter<Promise, T, Promise<T>>,
HK<Promise, T, Promise<T>> {
    public static <T> Promise<T> pure(T value) {
        return PromiseHelper.success(value);
    }

    public Future<T> getFuture();

    public T await() throws Exception;

    public T await(Duration var1) throws Exception;

    public Promise<T> onSuccess(Consumer<T> var1);

    public Promise<T> onFailure(Consumer<Throwable> var1);

    public Promise<T> onComplete(Consumer<Try<T>> var1);

    public <R> Promise<R> map(FunctionWithError<? super T, ? extends R> var1);

    public <R> Promise<R> biMap(FunctionWithError<? super T, ? extends R> var1, FunctionWithError<? super Throwable, ? extends R> var2);

    default public <R> Promise<R> and(FunctionWithError<? super T, R> function) {
        return this.map(function);
    }

    public <R> Promise<R> flatmap(Function<? super T, Promise<R>> var1);

    default public <R> Promise<R> then(Function<? super T, Promise<R>> function) {
        return this.flatmap(function);
    }
}

