/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.promise;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.smallibs.concurrent.promise.Promise;
import org.smallibs.concurrent.promise.impl.PromisesSet;
import org.smallibs.concurrent.promise.impl.SolvablePromise;
import org.smallibs.concurrent.promise.impl.SolvedPromise;
import org.smallibs.control.Applicative;
import org.smallibs.control.Functor;
import org.smallibs.control.Monad;
import org.smallibs.data.Try;
import org.smallibs.data.Unit;
import org.smallibs.type.HK;
import org.smallibs.util.FunctionsHelper;

public final class PromiseHelper
extends Enum<PromiseHelper> {
    private static final /* synthetic */ PromiseHelper[] $VALUES;

    public static PromiseHelper[] values() {
        return (PromiseHelper[])$VALUES.clone();
    }

    public static PromiseHelper valueOf(String name) {
        return Enum.valueOf(PromiseHelper.class, name);
    }

    public static <T> Functor<Promise, T, Promise<T>> functor(Promise<T> promise) {
        return () -> promise;
    }

    public static <T> Applicative<Promise, T, Promise<T>> applicative(Promise<T> promise) {
        return () -> promise;
    }

    public static <T> Monad<Promise, T, Promise<T>> monad(Promise<T> promise) {
        return () -> promise;
    }

    public static <T> Promise<T> success(T t) {
        return new SolvedPromise<T>(Try.success(t));
    }

    public static <T> Promise<T> failure(Throwable t) {
        return new SolvedPromise(Try.failure(t));
    }

    public static Promise<Unit> join(Promise ... promises) {
        return new PromisesSet(PromisesSet.Strategy.NO_STOP, promises);
    }

    public static <T> Promise<List<T>> sequence(List<Promise<T>> promises) {
        List result = Collections.synchronizedList(new ArrayList());
        SolvablePromise solvablePromise = new SolvablePromise();
        Promise[] promisesArray = (Promise[])promises.stream().map(p -> p.onSuccess(result::add)).toArray(Promise[]::new);
        PromiseHelper.join(promisesArray).onComplete(c -> solvablePromise.solve(Try.pure(result)));
        return solvablePromise;
    }

    public static Promise<Unit> forall(Promise ... promises) {
        return new PromisesSet(PromisesSet.Strategy.STOP_ON_ERROR, promises);
    }

    public static Promise<Unit> exists(Promise ... promises) {
        return new PromisesSet(PromisesSet.Strategy.STOP_ON_SUCCESS, promises);
    }

    private static <B, S extends HK<Promise, B, S>> HK<Promise, B, Promise<B>> specialize(HK<Promise, B, S> app) {
        return app;
    }

    private static <B, S extends HK<Promise, B, S>> HK<Promise, B, S> generalize(HK<Promise, B, Promise<B>> app) {
        return app;
    }

    private static /* synthetic */ PromiseHelper[] $values() {
        return new PromiseHelper[0];
    }

    static {
        $VALUES = PromiseHelper.$values();
    }

    @FunctionalInterface
    private static interface Functor4Promise<T>
    extends Functor<Promise, T, Promise<T>> {
        @Override
        default public <B, NS extends HK<Promise, B, NS>> HK<Promise, B, NS> map(Function<? super T, ? extends B> function) {
            return PromiseHelper.generalize(() -> ((Promise)this.self()).map(FunctionsHelper.fromFunction(function)));
        }
    }

    @FunctionalInterface
    private static interface Applicative4Promise<T>
    extends Functor4Promise<T>,
    Applicative<Promise, T, Promise<T>> {
        @Override
        default public <B, NS extends HK<Promise, B, NS>> HK<Promise, B, NS> apply(Functor<Promise, Function<? super T, ? extends B>, ?> functor) {
            return PromiseHelper.generalize(() -> ((Promise)this.self()).flatmap(a -> {
                HK map = functor.map((? super A bFunction) -> bFunction.apply(a));
                return PromiseHelper.specialize(map).self();
            }));
        }
    }

    private static interface Monad4Promise<T>
    extends Applicative4Promise<T>,
    Monad<Promise, T, Promise<T>> {
        @Override
        default public <B, NS extends HK<Promise, B, NS>> HK<Promise, B, NS> flatmap(Function<? super T, HK<Promise, B, NS>> function) {
            Function<Object, Promise> tPromiseFunction = t -> {
                HK apply = (HK)function.apply(t);
                return PromiseHelper.specialize(apply).self();
            };
            return PromiseHelper.generalize(() -> ((Promise)this.self()).flatmap(tPromiseFunction));
        }
    }
}

