/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.promise.impl;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.smallibs.concurrent.promise.impl.SolvableFuture;
import org.smallibs.concurrent.promise.impl.SolvablePromise;
import org.smallibs.data.Maybe;
import org.smallibs.data.Try;

public final class RunnablePromise<T>
extends SolvablePromise<T>
implements Runnable {
    private final Callable<T> callable;
    private WeakReference<Thread> currentExecutor;

    public RunnablePromise(Callable<T> callable) {
        Objects.requireNonNull(callable);
        this.currentExecutor = new WeakReference<Object>(null);
        this.callable = callable;
    }

    @Override
    public void run() {
        this.currentExecutor = new WeakReference<Thread>(Thread.currentThread());
        try {
            this.solve(Try.success(this.callable.call()));
        }
        catch (Throwable exception) {
            this.solve(Try.failure(exception));
        }
        this.currentExecutor.clear();
    }

    @Override
    protected SolvableFuture<T> createFuture(Consumer<Try<T>> callbackOnComplete) {
        return new SolvableFuture<T>(callbackOnComplete){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (mayInterruptIfRunning) {
                    Maybe.some((Thread)RunnablePromise.this.currentExecutor.get()).onSome(Thread::interrupt);
                }
                return super.cancel(mayInterruptIfRunning);
            }
        };
    }
}

