/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.data;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.smallibs.concurrent.promise.Promise;
import org.smallibs.concurrent.promise.PromiseHelper;
import org.smallibs.control.Filter;
import org.smallibs.exception.FilterException;
import org.smallibs.type.HK;
import org.smallibs.util.SupplierWithError;

public sealed interface Try<T>
extends Filter<Try, T, Try<T>>,
HK<Try, T, Try<T>> {
    public static <O> Try<O> handle(SupplierWithError<O> supplier) {
        try {
            return Try.pure(supplier.get());
        }
        catch (Throwable e) {
            return Try.failure(e);
        }
    }

    default public Promise<T> toPromise() {
        Try try_ = this;
        Objects.requireNonNull(try_);
        Try try_2 = try_;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Success.class, Failure.class}, (Object)try_2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Success v = (Success)try_2;
                yield PromiseHelper.success(v.value);
            }
            case 1 -> {
                Failure v = (Failure)try_2;
                yield PromiseHelper.failure(v.value);
            }
        };
    }

    public static <T> Try<T> pure(T value) {
        return Try.success(value);
    }

    public static <T> Try<T> success(T value) {
        if (Throwable.class.isInstance(value)) {
            return new Failure((Throwable)Throwable.class.cast(value));
        }
        return new Success<T>(value);
    }

    public static <T> Try<T> failure(Throwable value) {
        return new Failure(value);
    }

    default public Try<T> filter(Predicate<? super T> predicate) {
        return this.flatmap(t -> predicate.test(t) ? this : Try.failure(new FilterException()));
    }

    @Override
    default public Try<T> self() {
        return this;
    }

    default public <B> Try<B> map(Function<? super T, ? extends B> mapper) {
        return this.flatmap(t -> Try.success(mapper.apply(t)));
    }

    default public <B> B fold(Function<? super T, B> success, Function<? super Throwable, B> failure) {
        return this.map(success).recoverWith(failure);
    }

    default public T recoverWith(T t) {
        return (T)this.recoverWith(x -> t);
    }

    default public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return this.orElseThrow((? super Throwable x) -> (Throwable)exceptionSupplier.get());
    }

    default public T orElseThrow() throws Throwable {
        return this.orElseThrow((? super Throwable x) -> x);
    }

    default public boolean isSuccess() {
        return this.fold(t -> true, f -> false);
    }

    public T recoverWith(Function<? super Throwable, T> var1);

    public <X extends Throwable> T orElseThrow(Function<? super Throwable, ? extends X> var1) throws X;

    public <B> Try<B> flatmap(Function<? super T, Try<B>> var1);

    public Try<T> onSuccess(Consumer<? super T> var1);

    public Try<T> onFailure(Consumer<? super Throwable> var1);

    public record Success<T>(T value) implements Try<T>
    {
        @Override
        public <B> Try<B> flatmap(Function<? super T, Try<B>> mapper) {
            return mapper.apply(this.value);
        }

        @Override
        public Try<T> onSuccess(Consumer<? super T> onSuccess) {
            onSuccess.accept(this.value);
            return this;
        }

        @Override
        public Try<T> onFailure(Consumer<? super Throwable> onFailure) {
            return this;
        }

        @Override
        public <X extends Throwable> T orElseThrow(Function<? super Throwable, ? extends X> exceptionSupplier) throws X {
            return this.value;
        }

        @Override
        public T recoverWith(Function<? super Throwable, T> t) {
            return this.value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Success success = (Success)o;
            return Objects.equals(this.value, success.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    public record Failure<T>(Throwable value) implements Try<T>
    {
        @Override
        public <B> Try<B> flatmap(Function<? super T, Try<B>> mapper) {
            return Try.failure(this.value);
        }

        @Override
        public Try<T> onSuccess(Consumer<? super T> onSuccess) {
            return this;
        }

        @Override
        public Try<T> onFailure(Consumer<? super Throwable> onFailure) {
            onFailure.accept(this.value);
            return this;
        }

        @Override
        public <X extends Throwable> T orElseThrow(Function<? super Throwable, ? extends X> exceptionSupplier) throws X {
            throw (Throwable)exceptionSupplier.apply(this.value);
        }

        @Override
        public T recoverWith(Function<? super Throwable, T> t) {
            return t.apply(this.value);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public int hashCode() {
            return 13;
        }
    }
}

