/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.execution.impl;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.smallibs.concurrent.execution.Executor;
import org.smallibs.concurrent.promise.Promise;
import org.smallibs.concurrent.promise.impl.RunnablePromise;
import org.smallibs.data.Unit;

public final class ExecutorImpl
implements Executor {
    private final ExecutorService executorService;

    public ExecutorImpl(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public <T> Promise<T> async(Callable<T> task) {
        Objects.requireNonNull(task);
        RunnablePromise<T> runnablePromise = new RunnablePromise<T>(task);
        this.executorService.execute(runnablePromise);
        return runnablePromise;
    }

    @Override
    public Promise<Unit> async(Executor.RunnableWithError task) {
        Objects.requireNonNull(task);
        RunnablePromise<Unit> runnablePromise = new RunnablePromise<Unit>(() -> {
            task.run();
            return Unit.unit;
        });
        this.executorService.execute(runnablePromise);
        return runnablePromise;
    }
}

