/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.execution;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.smallibs.concurrent.execution.Executor;
import org.smallibs.concurrent.execution.impl.ExecutorImpl;
import org.smallibs.concurrent.promise.Promise;
import org.smallibs.data.Try;

public final class ExecutorHelper
extends Enum<ExecutorHelper> {
    private static final /* synthetic */ ExecutorHelper[] $VALUES;

    public static ExecutorHelper[] values() {
        return (ExecutorHelper[])$VALUES.clone();
    }

    public static ExecutorHelper valueOf(String name) {
        return Enum.valueOf(ExecutorHelper.class, name);
    }

    public static Executor create(ExecutorService executorService) {
        return new ExecutorImpl(executorService);
    }

    public static <T> Try<T> await(Promise<T> promise, Duration duration) {
        Objects.requireNonNull(promise);
        try {
            return Try.success(promise.getFuture().get(duration.toMillis(), TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException | TimeoutException e) {
            return Try.failure(e);
        }
        catch (ExecutionException e) {
            return Try.failure(e.getCause());
        }
    }

    private static /* synthetic */ ExecutorHelper[] $values() {
        return new ExecutorHelper[0];
    }

    static {
        $VALUES = ExecutorHelper.$values();
    }
}

