/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.promise.impl;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.smallibs.data.Try;

public class SolvableFuture<T>
implements Future<T> {
    private final AtomicReference<Try<T>> responseReference;
    private final Consumer<Try<T>> callbackOnComplete;
    private final AtomicReference<Status> status;

    public SolvableFuture(Consumer<Try<T>> callbackOnComplete) {
        this.callbackOnComplete = callbackOnComplete;
        this.responseReference = new AtomicReference();
        this.status = new AtomicReference<Status>(Status.WAITING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        SolvableFuture solvableFuture = this;
        synchronized (solvableFuture) {
            boolean isCancelled = this.status.compareAndSet(Status.WAITING, Status.CANCELLED);
            if (isCancelled) {
                this.responseReference.set(Try.failure(new CancellationException()));
            }
            return isCancelled;
        }
    }

    @Override
    public boolean isCancelled() {
        return this.status.get() == Status.CANCELLED;
    }

    @Override
    public boolean isDone() {
        return this.status.get() == Status.SOLVED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws InterruptedException, ExecutionException {
        SolvableFuture solvableFuture = this;
        synchronized (solvableFuture) {
            if (this.status.get() == Status.WAITING) {
                this.wait();
            }
        }
        return this.getNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        SolvableFuture solvableFuture = this;
        synchronized (solvableFuture) {
            if (this.status.get() == Status.WAITING) {
                this.wait(unit.toMillis(timeout));
            }
            if (this.status.get() == Status.WAITING) {
                throw new TimeoutException();
            }
        }
        return this.getNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean solve(Try<T> response) {
        boolean solved = this.isSolved(response);
        if (solved) {
            this.callbackOnComplete.accept(response);
            SolvableFuture solvableFuture = this;
            synchronized (solvableFuture) {
                this.notifyAll();
            }
        }
        return solved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSolved(Try<T> response) {
        SolvableFuture solvableFuture = this;
        synchronized (solvableFuture) {
            if (this.status.compareAndSet(Status.WAITING, Status.SOLVED)) {
                this.responseReference.set(response);
                return true;
            }
            return false;
        }
    }

    private T getNow() throws ExecutionException {
        return this.responseReference.get().orElseThrow(t -> {
            if (t instanceof ExecutionException) {
                return (ExecutionException)t;
            }
            return new ExecutionException((Throwable)t);
        });
    }

    private static enum Status {
        WAITING,
        SOLVED,
        CANCELLED;

    }
}

