/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.promise.impl;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.smallibs.concurrent.promise.Promise;
import org.smallibs.concurrent.promise.impl.AbstractPromise;
import org.smallibs.concurrent.promise.impl.SolvableFuture;
import org.smallibs.data.Try;

public class SolvablePromise<T>
extends AbstractPromise<T> {
    private final SolvableFuture<T> future = this.createFuture(this::notifyResponse);
    private CountDownLatch awaiting = null;
    private List<Consumer<T>> onSuccess = null;
    private List<Consumer<Throwable>> onError = null;

    @Override
    public Future<T> getFuture() {
        return this.future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T await(Duration duration) throws Throwable {
        boolean shouldAwait = false;
        SolvableFuture<T> solvableFuture = this.future;
        synchronized (solvableFuture) {
            shouldAwait = this.isNotCompleted();
            if (shouldAwait && this.awaiting == null) {
                this.awaiting = new CountDownLatch(1);
            }
        }
        if (shouldAwait) {
            try {
                boolean awaited = this.awaiting.await(duration.toMillis(), TimeUnit.MILLISECONDS);
                if (this.isNotCompleted() || !awaited) {
                    throw new TimeoutException();
                }
            }
            catch (InterruptedException awaited) {
                // empty catch block
            }
        }
        try {
            return this.future.get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<T> onSuccess(Consumer<T> consumer) {
        Objects.requireNonNull(consumer);
        SolvableFuture<T> solvableFuture = this.future;
        synchronized (solvableFuture) {
            if (this.isNotCompleted()) {
                if (this.onSuccess == null) {
                    this.onSuccess = new ArrayList<Consumer<T>>();
                }
                this.onSuccess.add(consumer);
                return this;
            }
        }
        try {
            consumer.accept(this.future.get());
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<T> onFailure(Consumer<Throwable> consumer) {
        Objects.requireNonNull(consumer);
        SolvableFuture<T> solvableFuture = this.future;
        synchronized (solvableFuture) {
            if (this.isNotCompleted()) {
                if (this.onError == null) {
                    this.onError = new ArrayList<Consumer<Throwable>>();
                }
                this.onError.add(consumer);
                return this;
            }
        }
        try {
            this.future.get();
        }
        catch (InterruptedException e) {
            consumer.accept(e);
        }
        catch (ExecutionException e) {
            consumer.accept(e.getCause());
        }
        return this;
    }

    @Override
    public Promise<T> onComplete(Consumer<Try<T>> consumer) {
        Objects.requireNonNull(consumer);
        return this.onSuccess(t -> consumer.accept(Try.success(t))).onFailure(throwable -> consumer.accept(Try.failure(throwable)));
    }

    public boolean solve(Try<T> response) {
        return this.future.solve(response);
    }

    protected SolvableFuture<T> createFuture(Consumer<Try<T>> callbackOnComplete) {
        return new SolvableFuture<T>(callbackOnComplete);
    }

    private boolean isNotCompleted() {
        return !this.future.isDone() && !this.future.isCancelled();
    }

    private void notifyResponse(Try<T> response) {
        if (this.awaiting != null) {
            this.awaiting.countDown();
        }
        response.onSuccess((? super T s) -> {
            if (this.onSuccess != null) {
                this.onSuccess.forEach(c -> c.accept(s));
                this.onSuccess.clear();
            }
        }).onFailure((? super Throwable t) -> {
            if (this.onError != null) {
                this.onError.forEach(c -> c.accept(t));
                this.onError.clear();
            }
        });
    }
}

