/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.asynchronous.impl;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.smallibs.concurrent.asynchronous.Executor;
import org.smallibs.concurrent.promise.Promise;
import org.smallibs.concurrent.promise.impl.RunnablePromise;

public final class ExecutorImpl
implements Executor {
    private final ExecutorService executorService;

    public ExecutorImpl(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public <T> Promise<T> async(Callable<T> task) {
        Objects.requireNonNull(task);
        RunnablePromise<T> runnablePromise = new RunnablePromise<T>(task);
        this.executorService.execute(runnablePromise);
        return runnablePromise;
    }

    @Override
    public <T> T await(Promise<T> promise) {
        Objects.requireNonNull(promise);
        try {
            return promise.getFuture().get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public <T> T await(Promise<T> promise, long duration, TimeUnit timeUnit) throws TimeoutException {
        Objects.requireNonNull(promise);
        try {
            return promise.getFuture().get(duration, timeUnit);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

