/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.promise;

import java.util.function.Function;
import org.smallibs.concurrent.promise.Promise;
import org.smallibs.concurrent.promise.impl.SolvedPromise;
import org.smallibs.control.Monad;
import org.smallibs.data.Try;
import org.smallibs.type.TApp;
import org.smallibs.util.FunctionsWithError;

public final class PromiseHelper {
    private PromiseHelper() {
    }

    public static <T> Monad<Promise, T, Promise<T>> monad(Promise<T> promise) {
        return new Monadic<T>(promise);
    }

    public static <T> Promise<T> success(T t) {
        return new SolvedPromise<T>(Try.success(t));
    }

    public static <T> Promise<T> failure(Throwable t) {
        return new SolvedPromise(Try.failure(t));
    }

    private static <B, Self extends TApp<Promise, B, Self>> TApp<Promise, B, Promise<B>> specialize(TApp<Promise, B, Self> app) {
        return app;
    }

    private static <B, Self extends TApp<Promise, B, Self>> TApp<Promise, B, Self> generalize(TApp<Promise, B, Promise<B>> app) {
        return app;
    }

    private static final class Monadic<T>
    implements Monad<Promise, T, Promise<T>> {
        private final Promise<T> promise;

        Monadic(Promise<T> promise) {
            this.promise = promise;
        }

        @Override
        public <B, NSelf extends TApp<Promise, B, NSelf>> TApp<Promise, B, NSelf> map(Function<? super T, B> function) {
            return PromiseHelper.generalize(new Monadic<B>(this.promise.map(FunctionsWithError.fromFunction(function))));
        }

        @Override
        public <B, NSelf extends TApp<Promise, B, NSelf>> TApp<Promise, B, NSelf> flatmap(Function<? super T, TApp<Promise, B, NSelf>> function) {
            Function<Object, Promise> tPromiseFunction = t -> {
                TApp apply = (TApp)function.apply(t);
                return (Promise)PromiseHelper.specialize(apply).self();
            };
            return PromiseHelper.generalize(new Monadic(this.promise.flatmap(tPromiseFunction)));
        }

        @Override
        public <T1> T1 accept(Function<TApp<Promise, T, Promise<T>>, T1> f) {
            return this.promise.accept(f);
        }

        @Override
        public Promise<T> self() {
            return this.promise;
        }
    }
}

