/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.promise.impl;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.smallibs.concurrent.promise.impl.AbstractPromise;
import org.smallibs.data.Maybe;
import org.smallibs.data.Try;
import org.smallibs.exception.PromiseException;

public final class RunnablePromise<T>
extends AbstractPromise<T>
implements RunnableFuture<T> {
    private final Callable<T> callable;
    private final AtomicReference<Try<T>> responseReference;
    private WeakReference<Thread> currentExecutor;
    private volatile boolean canceled;
    private Consumer<T> onSuccess;
    private Consumer<Throwable> onError;

    public RunnablePromise(Callable<T> callable) {
        Objects.requireNonNull(callable);
        this.callable = callable;
        this.responseReference = new AtomicReference();
        this.currentExecutor = new WeakReference<Object>(null);
        this.canceled = false;
        this.onSuccess = __ -> {};
        this.onError = __ -> {};
    }

    @Override
    public Future<T> getFuture() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(Consumer<T> consumer) {
        Objects.requireNonNull(consumer);
        Maybe success = Maybe.none();
        AtomicReference<Try<T>> atomicReference = this.responseReference;
        synchronized (atomicReference) {
            if (this.isDone() || this.isCancelled()) {
                if (this.responseReference.get().isSuccess()) {
                    success = Maybe.some(this.responseReference.get().success());
                }
            } else {
                this.onSuccess = consumer;
            }
        }
        if (success.hasSome()) {
            consumer.accept(success.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(Consumer<Throwable> consumer) {
        Objects.requireNonNull(consumer);
        Maybe<Object> failure = Maybe.none();
        AtomicReference<Try<T>> atomicReference = this.responseReference;
        synchronized (atomicReference) {
            if (this.isDone() || this.isCancelled()) {
                if (!this.responseReference.get().isSuccess()) {
                    failure = Maybe.some(this.responseReference.get().failure());
                }
            } else {
                this.onError = consumer;
            }
        }
        if (failure.hasSome()) {
            consumer.accept((Throwable)failure.get());
        }
    }

    @Override
    public void onComplete(Consumer<Try<T>> consumer) {
        Objects.requireNonNull(consumer);
        this.onSuccess(t -> consumer.accept(Try.success(t)));
        this.onFailure(throwable -> consumer.accept(Try.failure(throwable)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        AtomicReference<Try<T>> atomicReference = this.responseReference;
        synchronized (atomicReference) {
            if (this.isDone() || this.isCancelled()) {
                return false;
            }
            if (mayInterruptIfRunning) {
                Maybe.some((Thread)this.currentExecutor.get()).onSome(Thread::interrupt);
            }
            this.responseReference.set(Try.failure(new CancellationException()));
            this.canceled = true;
            return true;
        }
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public boolean isDone() {
        return this.responseReference.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws InterruptedException, ExecutionException {
        AtomicReference<Try<T>> atomicReference = this.responseReference;
        synchronized (atomicReference) {
            if (this.responseReference.get() == null) {
                this.responseReference.wait();
            }
        }
        return this.getNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        AtomicReference<Try<T>> atomicReference = this.responseReference;
        synchronized (atomicReference) {
            if (this.responseReference.get() == null) {
                this.responseReference.wait(unit.toMillis(timeout));
            }
            if (this.responseReference.get() == null) {
                throw new TimeoutException();
            }
        }
        return this.getNow();
    }

    @Override
    public void run() {
        this.currentExecutor = new WeakReference<Thread>(Thread.currentThread());
        try {
            this.manageResponse(Try.success(this.callable.call()));
        }
        catch (PromiseException exception) {
            this.manageResponse(Try.failure(exception.getCause()));
        }
        catch (Throwable exception) {
            this.manageResponse(Try.failure(exception));
        }
        this.currentExecutor.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageResponse(Try<T> response) {
        AtomicReference<Try<T>> atomicReference = this.responseReference;
        synchronized (atomicReference) {
            if (this.isCancelled()) {
                return;
            }
            this.responseReference.set(response);
        }
        response.onSuccess(s -> this.onSuccess.accept(s)).onFailure(t -> this.onError.accept((Throwable)t));
        atomicReference = this.responseReference;
        synchronized (atomicReference) {
            this.responseReference.notifyAll();
        }
    }

    private T getNow() throws ExecutionException {
        if (this.responseReference.get().isSuccess()) {
            return this.responseReference.get().success();
        }
        throw new ExecutionException(this.responseReference.get().failure());
    }
}

