/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.data;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.smallibs.control.Filter;
import org.smallibs.type.TApp;

public abstract class Maybe<T>
implements Filter<Maybe, T, Maybe<T>>,
TApp<Maybe, T, Maybe<T>> {
    private Maybe() {
    }

    public static <T> Maybe<T> some(T value) {
        if (value == null) {
            return Maybe.none();
        }
        return new Some(value);
    }

    public static <T> Maybe<T> none() {
        return new None();
    }

    @Override
    public <R> R accept(Function<TApp<Maybe, T, Maybe<T>>, R> f) {
        return f.apply(this);
    }

    public Maybe<T> filter(Predicate<? super T> predicate) {
        if (this.hasSome() && predicate.test(this.get())) {
            return this;
        }
        return Maybe.none();
    }

    public <B> Maybe<B> map(Function<? super T, B> mapper) {
        if (this.hasSome()) {
            return Maybe.some(mapper.apply(this.get()));
        }
        return Maybe.none();
    }

    public <B> Maybe<B> flatmap(Function<? super T, Maybe<B>> mapper) {
        if (this.hasSome()) {
            return mapper.apply(this.get());
        }
        return Maybe.none();
    }

    public Maybe<T> onSome(Consumer<T> onSuccess) {
        if (this.hasSome()) {
            onSuccess.accept(this.get());
        }
        return this;
    }

    public T orElse(Supplier<T> t) {
        if (this.hasSome()) {
            return this.get();
        }
        return t.get();
    }

    public T orElse(T t) {
        if (this.hasSome()) {
            return this.get();
        }
        return t;
    }

    public abstract boolean hasSome();

    public abstract T get();

    @Override
    public Maybe<T> self() {
        return this;
    }

    private static final class None<T>
    extends Maybe<T> {
        private None() {
        }

        @Override
        public boolean hasSome() {
            return false;
        }

        @Override
        public T get() {
            throw new IllegalAccessError();
        }
    }

    private static final class Some<T>
    extends Maybe<T> {
        private final T value;

        private Some(T value) {
            this.value = value;
        }

        @Override
        public boolean hasSome() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }
    }
}

