/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.data;

import java.util.function.Function;
import org.smallibs.control.Monad;
import org.smallibs.data.Maybe;
import org.smallibs.data.Try;
import org.smallibs.exception.NoValueException;
import org.smallibs.type.TApp;

public class MaybeHelper {
    private MaybeHelper() {
    }

    public static <T> Monad<Maybe, T, Maybe<T>> monad(Maybe<T> maybe) {
        return new Monadic(maybe);
    }

    public static <T> Try<T> toTry(Maybe<T> maybe) {
        return maybe.map(Try::success).orElse(Try.failure(new NoValueException()));
    }

    private static <B, Self extends TApp<Maybe, B, Self>> TApp<Maybe, B, Maybe<B>> specialize(TApp<Maybe, B, Self> app) {
        return app;
    }

    private static <B, Self extends TApp<Maybe, B, Self>> TApp<Maybe, B, Self> generalize(TApp<Maybe, B, Maybe<B>> app) {
        return app;
    }

    static final class Monadic<T>
    implements Monad<Maybe, T, Maybe<T>> {
        private final Maybe<T> aMaybe;

        private Monadic(Maybe<T> aMaybe) {
            this.aMaybe = aMaybe;
        }

        @Override
        public <B, NSelf extends TApp<Maybe, B, NSelf>> TApp<Maybe, B, NSelf> map(Function<? super T, B> function) {
            return MaybeHelper.generalize(new Monadic<B>(this.aMaybe.map(function)));
        }

        @Override
        public <B, NSelf extends TApp<Maybe, B, NSelf>> TApp<Maybe, B, NSelf> flatmap(Function<? super T, TApp<Maybe, B, NSelf>> function) {
            Function<Object, Maybe> tMaybeFunction = t -> {
                TApp apply = (TApp)function.apply(t);
                return (Maybe)MaybeHelper.specialize(apply).self();
            };
            return MaybeHelper.generalize(new Monadic(this.aMaybe.flatmap(tMaybeFunction)));
        }

        @Override
        public <T1> T1 accept(Function<TApp<Maybe, T, Maybe<T>>, T1> f) {
            return this.aMaybe.accept(f);
        }

        @Override
        public Maybe<T> self() {
            return this.aMaybe;
        }
    }
}

