/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.data;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.smallibs.control.Filter;
import org.smallibs.exception.FilterException;
import org.smallibs.type.TApp;

public abstract class Try<T>
implements Filter<Try, T, Try<T>>,
TApp<Try, T, Try<T>> {
    private Try() {
    }

    public static <T> Try<T> success(T value) {
        return new Success(value);
    }

    public static <T> Try<T> failure(Throwable value) {
        return new Failure(value);
    }

    public Try<T> filter(Predicate<? super T> predicate) {
        if (this.isSuccess() && predicate.test(this.success())) {
            return this;
        }
        return Try.failure(new FilterException());
    }

    @Override
    public <R> R accept(Function<TApp<Try, T, Try<T>>, R> f) {
        return f.apply(this);
    }

    public <B> Try<B> map(Function<? super T, B> mapper) {
        if (this.isSuccess()) {
            return Try.success(mapper.apply(this.success()));
        }
        return Try.failure(this.failure());
    }

    public <B> Try<B> flatmap(Function<? super T, Try<B>> mapper) {
        if (this.isSuccess()) {
            return mapper.apply(this.success());
        }
        return Try.failure(this.failure());
    }

    public T recoverWith(T t) {
        if (this.isSuccess()) {
            return this.success();
        }
        return t;
    }

    public Try<T> onSuccess(Consumer<T> onSuccess) {
        if (this.isSuccess()) {
            onSuccess.accept(this.success());
        }
        return this;
    }

    public Try<T> onFailure(Consumer<Throwable> onFailure) {
        if (!this.isSuccess()) {
            onFailure.accept(this.failure());
        }
        return this;
    }

    public T recoverWith(Function<Throwable, T> t) {
        if (this.isSuccess()) {
            return this.success();
        }
        return t.apply(this.failure());
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isSuccess()) {
            return this.success();
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public <X extends Throwable> T orElseRetrieveAndThrow(Function<Throwable, ? extends X> exceptionSupplier) throws X {
        if (this.isSuccess()) {
            return this.success();
        }
        throw (Throwable)exceptionSupplier.apply(this.failure());
    }

    public T orElseRetrieveAndThrow() throws Throwable {
        if (this.isSuccess()) {
            return this.success();
        }
        throw this.failure();
    }

    public abstract boolean isSuccess();

    public abstract T success();

    public abstract Throwable failure();

    @Override
    public Try<T> self() {
        return this;
    }

    private static final class Failure<T>
    extends Try<T> {
        private final Throwable value;

        private Failure(Throwable value) {
            this.value = value;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public T success() {
            throw new IllegalAccessError();
        }

        @Override
        public Throwable failure() {
            return this.value;
        }
    }

    private static final class Success<T>
    extends Try<T> {
        private final T value;

        private Success(T value) {
            this.value = value;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public T success() {
            return this.value;
        }

        @Override
        public Throwable failure() {
            throw new IllegalAccessError();
        }
    }
}

