/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.data;

import java.util.function.Function;
import org.smallibs.control.Monad;
import org.smallibs.data.Maybe;
import org.smallibs.data.Try;
import org.smallibs.type.TApp;

public class TryHelper {
    public static <T> Monad<Try, T, Try<T>> monad(Try<T> aTry) {
        return new Monadic(aTry);
    }

    public static <T> Maybe<T> toMaybe(Try<T> aTry) {
        return aTry.map(Maybe::some).recoverWith(Maybe.none());
    }

    private static <B, Self extends TApp<Try, B, Self>> TApp<Try, B, Try<B>> specialize(TApp<Try, B, Self> app) {
        return app;
    }

    private static <B, Self extends TApp<Try, B, Self>> TApp<Try, B, Self> generalize(TApp<Try, B, Try<B>> app) {
        return app;
    }

    static final class Monadic<T>
    implements Monad<Try, T, Try<T>> {
        private final Try<T> aTry;

        private Monadic(Try<T> aTry) {
            this.aTry = aTry;
        }

        @Override
        public <B, NSelf extends TApp<Try, B, NSelf>> TApp<Try, B, NSelf> map(Function<? super T, B> function) {
            return TryHelper.generalize(new Monadic<B>(this.aTry.map(function)));
        }

        @Override
        public <B, NSelf extends TApp<Try, B, NSelf>> TApp<Try, B, NSelf> flatmap(Function<? super T, TApp<Try, B, NSelf>> function) {
            Function<Object, Try> tTryFunction = t -> {
                TApp apply = (TApp)function.apply(t);
                return (Try)TryHelper.specialize(apply).self();
            };
            return TryHelper.generalize(new Monadic(this.aTry.flatmap(tTryFunction)));
        }

        @Override
        public <T1> T1 accept(Function<TApp<Try, T, Try<T>>, T1> f) {
            return this.aTry.accept(f);
        }

        @Override
        public Try<T> self() {
            return this.aTry;
        }
    }
}

