/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.promise.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.smallibs.concurrent.promise.impl.AbstractPromise;
import org.smallibs.data.Maybe;
import org.smallibs.data.Try;

public class PassivePromise<T>
extends AbstractPromise<T>
implements Future<T> {
    private final AtomicReference<Try<T>> responseReference = new AtomicReference();
    private final List<Consumer<T>> onSuccess = new ArrayList<Consumer<T>>();
    private final List<Consumer<Throwable>> onError = new ArrayList<Consumer<Throwable>>();
    private volatile boolean canceled = false;

    @Override
    public Future<T> getFuture() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(Consumer<T> consumer) {
        Objects.requireNonNull(consumer);
        AtomicReference success = new AtomicReference();
        AtomicReference<Try<T>> atomicReference = this.responseReference;
        synchronized (atomicReference) {
            if (this.isPerformed()) {
                this.responseReference.get().onSuccess(success::set);
            } else {
                this.onSuccess.add(consumer);
            }
        }
        Maybe.some(success.get()).onSome(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(Consumer<Throwable> consumer) {
        Objects.requireNonNull(consumer);
        AtomicReference failure = new AtomicReference();
        AtomicReference<Try<T>> atomicReference = this.responseReference;
        synchronized (atomicReference) {
            if (this.isPerformed()) {
                this.responseReference.get().onFailure(failure::set);
            } else {
                this.onError.add(consumer);
            }
        }
        Maybe.some(failure.get()).onSome(consumer);
    }

    @Override
    public void onComplete(Consumer<Try<T>> consumer) {
        Objects.requireNonNull(consumer);
        this.onSuccess(t -> consumer.accept(Try.success(t)));
        this.onFailure(throwable -> consumer.accept(Try.failure(throwable)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        AtomicReference<Try<T>> atomicReference = this.responseReference;
        synchronized (atomicReference) {
            if (this.isPerformed()) {
                return false;
            }
            this.responseReference.set(Try.failure(new CancellationException()));
            this.canceled = true;
            return true;
        }
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public boolean isDone() {
        return this.responseReference.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws InterruptedException, ExecutionException {
        AtomicReference<Try<T>> atomicReference = this.responseReference;
        synchronized (atomicReference) {
            if (this.responseReference.get() == null) {
                this.responseReference.wait();
            }
        }
        return this.getNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        AtomicReference<Try<T>> atomicReference = this.responseReference;
        synchronized (atomicReference) {
            if (this.responseReference.get() == null) {
                this.responseReference.wait(unit.toMillis(timeout));
            }
            if (this.responseReference.get() == null) {
                throw new TimeoutException();
            }
        }
        return this.getNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void response(Try<T> response) {
        AtomicReference<Try<T>> atomicReference = this.responseReference;
        synchronized (atomicReference) {
            if (this.isCancelled()) {
                return;
            }
            this.responseReference.set(response);
        }
        response.onSuccess((? super T s) -> {
            this.onSuccess.forEach(c -> c.accept(s));
            this.onSuccess.clear();
        }).onFailure((? super Throwable t) -> {
            this.onError.forEach(c -> c.accept(t));
            this.onError.clear();
        });
        atomicReference = this.responseReference;
        synchronized (atomicReference) {
            this.responseReference.notifyAll();
        }
    }

    private boolean isPerformed() {
        return this.isDone() || this.isCancelled();
    }

    private T getNow() throws ExecutionException {
        return this.responseReference.get().orElseThrow(t -> new ExecutionException((Throwable)t));
    }
}

