/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.promise.impl;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;
import org.smallibs.concurrent.promise.impl.PassivePromise;
import org.smallibs.data.Maybe;
import org.smallibs.data.Try;

public final class RunnablePromise<T>
extends PassivePromise<T>
implements RunnableFuture<T> {
    private final Callable<T> callable;
    private WeakReference<Thread> currentExecutor;

    public RunnablePromise(Callable<T> callable) {
        Objects.requireNonNull(callable);
        this.currentExecutor = new WeakReference<Object>(null);
        this.callable = callable;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (mayInterruptIfRunning) {
            Maybe.some(this.currentExecutor.get()).onSome(Thread::interrupt);
        }
        return super.cancel(mayInterruptIfRunning);
    }

    @Override
    public void run() {
        this.currentExecutor = new WeakReference<Thread>(Thread.currentThread());
        try {
            this.response(Try.success(this.callable.call()));
        }
        catch (Throwable exception) {
            this.response(Try.failure(exception));
        }
        this.currentExecutor.clear();
    }
}

