/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.promise.impl;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.smallibs.concurrent.promise.impl.AbstractPromise;
import org.smallibs.data.Try;

public final class SolvedPromise<T>
extends AbstractPromise<T> {
    private final Try<T> value;

    public SolvedPromise(Try<T> value) {
        this.value = value;
    }

    @Override
    public Future<T> getFuture() {
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                return SolvedPromise.this.value.orElseThrow(t -> new ExecutionException((Throwable)t));
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.get();
            }
        };
    }

    @Override
    public void onSuccess(Consumer<T> consumer) {
        this.value.onSuccess(consumer);
    }

    @Override
    public void onFailure(Consumer<Throwable> consumer) {
        this.value.onFailure(consumer);
    }

    @Override
    public void onComplete(Consumer<Try<T>> consumer) {
        consumer.accept(this.value);
    }
}

