/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.data;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.smallibs.control.Filter;
import org.smallibs.exception.FilterException;
import org.smallibs.type.HK;

public interface Try<T>
extends Filter<Try, T, Try<T>>,
HK<Try, T, Try<T>> {
    public static <T> Try<T> success(T value) {
        if (Throwable.class.isInstance(value)) {
            return new Failure((Throwable)Throwable.class.cast(value));
        }
        return new Success(value);
    }

    public static <T> Try<T> failure(Throwable value) {
        return new Failure(value);
    }

    default public Try<T> filter(Predicate<? super T> predicate) {
        return this.flatmap(t -> predicate.test(t) ? this : Try.failure(new FilterException()));
    }

    @Override
    default public <R> R accept(Function<HK<Try, T, Try<T>>, R> f) {
        return f.apply(this);
    }

    @Override
    default public Try<T> self() {
        return this;
    }

    default public <B> Try<B> map(Function<? super T, B> mapper) {
        return this.flatmap(t -> Try.success(mapper.apply(t)));
    }

    default public <B> B fold(Function<? super T, B> success, Function<? super Throwable, B> failure) {
        return this.map(success).recoverWith(failure);
    }

    default public T recoverWith(T t) {
        return (T)this.recoverWith(x -> t);
    }

    default public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return this.orElseThrow((? super Throwable x) -> (Throwable)exceptionSupplier.get());
    }

    default public T orElseThrow() throws Throwable {
        return this.orElseThrow((? super Throwable x) -> x);
    }

    default public boolean isSuccess() {
        return this.fold(t -> true, f -> false);
    }

    public T recoverWith(Function<? super Throwable, T> var1);

    public <X extends Throwable> T orElseThrow(Function<? super Throwable, ? extends X> var1) throws X;

    public <B> Try<B> flatmap(Function<? super T, Try<B>> var1);

    public Try<T> onSuccess(Consumer<? super T> var1);

    public Try<T> onFailure(Consumer<? super Throwable> var1);

    public static final class Failure<T>
    implements Try<T> {
        private final Throwable value;

        private Failure(Throwable value) {
            this.value = value;
        }

        @Override
        public <B> Try<B> flatmap(Function<? super T, Try<B>> mapper) {
            return Try.failure(this.value);
        }

        @Override
        public Try<T> onSuccess(Consumer<? super T> onSuccess) {
            return this;
        }

        @Override
        public Try<T> onFailure(Consumer<? super Throwable> onFailure) {
            onFailure.accept(this.value);
            return this;
        }

        @Override
        public <X extends Throwable> T orElseThrow(Function<? super Throwable, ? extends X> exceptionSupplier) throws X {
            throw (Throwable)exceptionSupplier.apply(this.value);
        }

        @Override
        public T recoverWith(Function<? super Throwable, T> t) {
            return t.apply(this.value);
        }
    }

    public static final class Success<T>
    implements Try<T> {
        private final T value;

        private Success(T value) {
            this.value = value;
        }

        @Override
        public <B> Try<B> flatmap(Function<? super T, Try<B>> mapper) {
            return mapper.apply(this.value);
        }

        @Override
        public Try<T> onSuccess(Consumer<? super T> onSuccess) {
            onSuccess.accept(this.value);
            return this;
        }

        @Override
        public Try<T> onFailure(Consumer<? super Throwable> onFailure) {
            return this;
        }

        @Override
        public <X extends Throwable> T orElseThrow(Function<? super Throwable, ? extends X> exceptionSupplier) throws X {
            return this.value;
        }

        @Override
        public T recoverWith(Function<? super Throwable, T> t) {
            return this.value;
        }
    }
}

