/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.promise.impl;

import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import org.smallibs.concurrent.promise.Promise;
import org.smallibs.concurrent.promise.impl.AbstractPromise;
import org.smallibs.concurrent.promise.impl.FlatMappedFuture;
import org.smallibs.data.Try;

final class FlatMappedPromise<T, R>
extends AbstractPromise<R> {
    private final Promise<T> promise;
    private final Function<? super T, Promise<R>> transform;

    FlatMappedPromise(Promise<T> promise, Function<? super T, Promise<R>> transform) {
        this.promise = promise;
        this.transform = transform;
    }

    @Override
    public Future<R> getFuture() {
        return new FlatMappedFuture<T, R>(this.promise.getFuture(), this.transform);
    }

    @Override
    public void onSuccess(Consumer<R> consumer) {
        this.promise.onSuccess((T t) -> this.transform.apply(t).onSuccess(consumer));
    }

    @Override
    public void onFailure(Consumer<Throwable> consumer) {
        this.promise.onFailure(consumer);
    }

    @Override
    public void onComplete(Consumer<Try<R>> consumer) {
        this.promise.onComplete((Try<T> value) -> value.map(this.transform).onSuccess((? super T o) -> o.onComplete(consumer)).onFailure((? super Throwable t) -> consumer.accept(Try.failure(t))));
    }
}

