/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.promise.impl;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.smallibs.concurrent.promise.Promise;
import org.smallibs.concurrent.promise.impl.SolvablePromise;
import org.smallibs.data.Try;
import org.smallibs.data.Unit;

public class PromisesSet
extends SolvablePromise<Unit> {
    private final Strategy strategy;
    private final Promise<?>[] promises;
    private final AtomicInteger activePromises;

    public PromisesSet(Strategy strategy, Promise<?> ... promises) {
        this.strategy = strategy;
        this.promises = promises;
        this.activePromises = new AtomicInteger(this.promises.length);
        if (this.promises.length == 0) {
            this.solve(Try.success(Unit.unit));
            return;
        }
        Arrays.asList(this.promises).forEach(promise -> {
            promise.onSuccess(__ -> {
                this.activePromises.decrementAndGet();
                this.manageSuccess();
            });
            promise.onFailure(e -> {
                this.activePromises.decrementAndGet();
                this.manageError((Throwable)e);
            });
        });
    }

    private final void manageSuccess() {
        switch (this.strategy) {
            case STOP_ON_SUCCESS: {
                this.solve(Try.success(Unit.unit));
                Arrays.asList(this.promises).forEach(promise -> promise.getFuture().cancel(true));
                break;
            }
            default: {
                if (this.activePromises.get() != 0) break;
                this.solve(Try.success(Unit.unit));
            }
        }
    }

    private final void manageError(Throwable t) {
        switch (this.strategy) {
            case STOP_ON_ERROR: {
                this.solve(Try.failure(t));
                Arrays.asList(this.promises).forEach(promise -> promise.getFuture().cancel(true));
                break;
            }
            case STOP_ON_SUCCESS: {
                if (this.activePromises.get() != 0) break;
                this.solve(Try.failure(t));
                break;
            }
            default: {
                if (this.activePromises.get() != 0) break;
                this.solve(Try.success(Unit.unit));
            }
        }
    }

    public static enum Strategy {
        NO_STOP,
        STOP_ON_ERROR,
        STOP_ON_SUCCESS;

    }
}

