/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.promise.impl;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.smallibs.data.Try;

public class SolvableFuture<T>
implements Future<T> {
    private final AtomicReference<Try<T>> responseReference;
    private final Consumer<Try<T>> callbackOnComplete;
    private volatile boolean canceled;

    public SolvableFuture(Consumer<Try<T>> callbackOnComplete) {
        this.callbackOnComplete = callbackOnComplete;
        this.responseReference = new AtomicReference();
        this.canceled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        AtomicReference<Try<T>> atomicReference = this.responseReference;
        synchronized (atomicReference) {
            if (this.isPerformed()) {
                return false;
            }
            this.responseReference.set(Try.failure(new CancellationException()));
            this.canceled = true;
            return true;
        }
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public boolean isDone() {
        return this.responseReference.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws InterruptedException, ExecutionException {
        AtomicReference<Try<T>> atomicReference = this.responseReference;
        synchronized (atomicReference) {
            if (this.responseReference.get() == null) {
                this.responseReference.wait();
            }
        }
        return this.getNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        AtomicReference<Try<T>> atomicReference = this.responseReference;
        synchronized (atomicReference) {
            if (this.responseReference.get() == null) {
                this.responseReference.wait(unit.toMillis(timeout));
            }
            if (this.responseReference.get() == null) {
                throw new TimeoutException();
            }
        }
        return this.getNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void solve(Try<T> response) {
        AtomicReference<Try<T>> atomicReference = this.responseReference;
        synchronized (atomicReference) {
            if (this.isPerformed()) {
                return;
            }
            this.responseReference.set(response);
        }
        this.callbackOnComplete.accept(response);
        atomicReference = this.responseReference;
        synchronized (atomicReference) {
            this.responseReference.notifyAll();
        }
    }

    private boolean isPerformed() {
        return this.isDone() || this.isCancelled();
    }

    private T getNow() throws ExecutionException {
        return this.responseReference.get().orElseThrow(t -> {
            if (t instanceof ExecutionException) {
                return (ExecutionException)t;
            }
            return new ExecutionException((Throwable)t);
        });
    }
}

