/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.promise.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.smallibs.concurrent.promise.Promise;
import org.smallibs.concurrent.promise.impl.AbstractPromise;
import org.smallibs.concurrent.promise.impl.SolvableFuture;
import org.smallibs.data.Maybe;
import org.smallibs.data.Try;

public class SolvablePromise<T>
extends AbstractPromise<T> {
    private final SolvableFuture<T> future = this.createFuture(this::notifyResponse);
    private final List<Consumer<T>> onSuccess = new ArrayList<Consumer<T>>();
    private final List<Consumer<Throwable>> onError = new ArrayList<Consumer<Throwable>>();

    @Override
    public Future<T> getFuture() {
        return this.future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<T> onSuccess(Consumer<T> consumer) {
        Objects.requireNonNull(consumer);
        AtomicReference<T> success = new AtomicReference<T>();
        SolvableFuture<T> solvableFuture = this.future;
        synchronized (solvableFuture) {
            if (this.future.isDone() || this.future.isCancelled()) {
                try {
                    success.set(this.future.get());
                }
                catch (InterruptedException | ExecutionException exception) {}
            } else {
                this.onSuccess.add(consumer);
            }
        }
        Maybe.some(success.get()).onSome(consumer);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<T> onFailure(Consumer<Throwable> consumer) {
        Objects.requireNonNull(consumer);
        AtomicReference<Throwable> failure = new AtomicReference<Throwable>();
        SolvableFuture<T> solvableFuture = this.future;
        synchronized (solvableFuture) {
            if (this.future.isDone() || this.future.isCancelled()) {
                try {
                    this.future.get();
                }
                catch (ExecutionException e) {
                    failure.set(e.getCause());
                }
                catch (InterruptedException e) {
                    failure.set(e);
                }
            } else {
                this.onError.add(consumer);
            }
        }
        Maybe.some(failure.get()).onSome(consumer);
        return this;
    }

    @Override
    public Promise<T> onComplete(Consumer<Try<T>> consumer) {
        Objects.requireNonNull(consumer);
        this.onSuccess(t -> consumer.accept(Try.success(t)));
        this.onFailure(throwable -> consumer.accept(Try.failure(throwable)));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void solve(Try<T> response) {
        SolvableFuture<T> solvableFuture = this.future;
        synchronized (solvableFuture) {
            this.future.solve(response);
        }
        this.notifyResponse(response);
    }

    protected SolvableFuture<T> createFuture(Consumer<Try<T>> callbackOnComplete) {
        return new SolvableFuture<T>(callbackOnComplete);
    }

    private void notifyResponse(Try<T> response) {
        response.onSuccess((? super T s) -> {
            this.onSuccess.forEach(c -> c.accept(s));
            this.onSuccess.clear();
        }).onFailure((? super Throwable t) -> {
            this.onError.forEach(c -> c.accept(t));
            this.onError.clear();
        });
    }
}

