/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.promise;

import java.util.function.Function;
import org.smallibs.concurrent.promise.Promise;
import org.smallibs.concurrent.promise.impl.PromisesSet;
import org.smallibs.concurrent.promise.impl.SolvedPromise;
import org.smallibs.control.Applicative;
import org.smallibs.control.Functor;
import org.smallibs.control.Monad;
import org.smallibs.data.Try;
import org.smallibs.data.Unit;
import org.smallibs.type.HK;
import org.smallibs.util.FunctionsHelper;

public enum PromiseHelper {


    public static <T> Functor<Promise, T, Promise<T>> functor(Promise<T> promise) {
        return () -> promise;
    }

    public static <T> Applicative<Promise, T, Promise<T>> applicative(Promise<T> promise) {
        return () -> promise;
    }

    public static <T> Monad<Promise, T, Promise<T>> monad(Promise<T> promise) {
        return () -> promise;
    }

    public static <T> Promise<T> success(T t) {
        return new SolvedPromise<T>(Try.success(t));
    }

    public static <T> Promise<T> failure(Throwable t) {
        return new SolvedPromise(Try.failure(t));
    }

    @SafeVarargs
    public static <T> Promise<Unit> join(Promise<T> ... promises) {
        return new PromisesSet(PromisesSet.Strategy.NO_STOP, promises);
    }

    @SafeVarargs
    public static <T> Promise<Unit> forall(Promise ... promises) {
        return new PromisesSet(PromisesSet.Strategy.STOP_ON_ERROR, promises);
    }

    @SafeVarargs
    public static <T> Promise<Unit> exists(Promise ... promises) {
        return new PromisesSet(PromisesSet.Strategy.STOP_ON_SUCCESS, promises);
    }

    private static <B, Self extends HK<Promise, B, Self>> HK<Promise, B, Promise<B>> specialize(HK<Promise, B, Self> app) {
        return app;
    }

    private static <B, Self extends HK<Promise, B, Self>> HK<Promise, B, Self> generalize(HK<Promise, B, Promise<B>> app) {
        return app;
    }

    private static interface Monad4Promise<T>
    extends Applicative4Promise<T>,
    Monad<Promise, T, Promise<T>> {
        @Override
        default public <B, NSelf extends HK<Promise, B, NSelf>> HK<Promise, B, NSelf> flatmap(Function<? super T, HK<Promise, B, NSelf>> function) {
            Function<Object, Promise> tPromiseFunction = t -> {
                HK apply = (HK)function.apply(t);
                return (Promise)PromiseHelper.specialize(apply).self();
            };
            return PromiseHelper.generalize(() -> ((Promise)this.self()).flatmap(tPromiseFunction));
        }
    }

    @FunctionalInterface
    private static interface Applicative4Promise<T>
    extends Functor4Promise<T>,
    Applicative<Promise, T, Promise<T>> {
        @Override
        default public <B, NSelf extends HK<Promise, B, NSelf>> HK<Promise, B, NSelf> apply(Functor<Promise, Function<? super T, ? extends B>, ?> functor) {
            return PromiseHelper.generalize(() -> ((Promise)this.self()).flatmap(a -> {
                HK map = functor.map((? super A bFunction) -> bFunction.apply(a));
                return (Promise)PromiseHelper.specialize(map).self();
            }));
        }
    }

    @FunctionalInterface
    private static interface Functor4Promise<T>
    extends Functor<Promise, T, Promise<T>> {
        @Override
        default public <B, NSelf extends HK<Promise, B, NSelf>> HK<Promise, B, NSelf> map(Function<? super T, ? extends B> function) {
            return PromiseHelper.generalize(() -> ((Promise)this.self()).map(FunctionsHelper.fromFunction(function)));
        }

        @Override
        default public <T1> T1 apply(Function<HK<Promise, T, Promise<T>>, T1> f) {
            return ((Promise)this.self()).apply(f);
        }
    }
}

