/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.data;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.smallibs.control.Filter;
import org.smallibs.type.HK;

public interface Maybe<T>
extends Filter<Maybe, T, Maybe<T>>,
HK<Maybe, T, Maybe<T>> {
    public static <T> Maybe<T> some(T value) {
        if (value == null) {
            return Maybe.none();
        }
        return new Some(value);
    }

    public static <T> Maybe<T> none() {
        return new None();
    }

    @Override
    default public <R> R apply(Function<HK<Maybe, T, Maybe<T>>, R> f) {
        return f.apply(this);
    }

    @Override
    default public Maybe<T> self() {
        return this;
    }

    default public Maybe<T> filter(Predicate<? super T> predicate) {
        return this.flatmap(t -> predicate.test(t) ? this : Maybe.none());
    }

    default public <B> Maybe<B> map(Function<? super T, ? extends B> mapper) {
        return this.flatmap(x -> Maybe.some(mapper.apply(x)));
    }

    default public <B> B fold(Function<? super T, B> some, Supplier<B> none) {
        return this.map(some).orElse(none);
    }

    default public T orElse(T t) {
        return (T)this.orElse(() -> t);
    }

    default public boolean hasSome() {
        return this.fold(__ -> true, () -> false);
    }

    public Maybe<T> onSome(Consumer<T> var1);

    public Maybe<T> onNone(Runnable var1);

    public <B> Maybe<B> flatmap(Function<? super T, Maybe<B>> var1);

    public T orElse(Supplier<T> var1);

    public static final class None<T>
    implements Maybe<T> {
        @Override
        public boolean hasSome() {
            return false;
        }

        @Override
        public <B> Maybe<B> flatmap(Function<? super T, Maybe<B>> mapper) {
            return Maybe.none();
        }

        @Override
        public Maybe<T> onSome(Consumer<T> onSuccess) {
            return this;
        }

        @Override
        public Maybe<T> onNone(Runnable onNone) {
            onNone.run();
            return this;
        }

        @Override
        public T orElse(Supplier<T> t) {
            return t.get();
        }
    }

    public static final class Some<T>
    implements Maybe<T> {
        private final T value;

        private Some(T value) {
            this.value = value;
        }

        @Override
        public boolean hasSome() {
            return true;
        }

        @Override
        public <B> Maybe<B> flatmap(Function<? super T, Maybe<B>> mapper) {
            return mapper.apply(this.value);
        }

        @Override
        public Maybe<T> onSome(Consumer<T> onSuccess) {
            onSuccess.accept(this.value);
            return this;
        }

        @Override
        public Maybe<T> onNone(Runnable onNone) {
            return this;
        }

        @Override
        public T orElse(Supplier<T> t) {
            return this.value;
        }
    }
}

