/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.concurrent.promise.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.smallibs.concurrent.promise.Promise;
import org.smallibs.concurrent.promise.impl.AbstractPromise;
import org.smallibs.concurrent.promise.impl.SolvableFuture;
import org.smallibs.data.Try;

public class SolvablePromise<T>
extends AbstractPromise<T> {
    private final SolvableFuture<T> future = this.createFuture(this::notifyResponse);
    private final List<Consumer<T>> onSuccess = new ArrayList<Consumer<T>>();
    private final List<Consumer<Throwable>> onError = new ArrayList<Consumer<Throwable>>();

    @Override
    public Future<T> getFuture() {
        return this.future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<T> onSuccess(Consumer<T> consumer) {
        T value;
        Objects.requireNonNull(consumer);
        SolvableFuture<T> solvableFuture = this.future;
        synchronized (solvableFuture) {
            if (this.future.isDone() || this.future.isCancelled()) {
                try {
                    value = this.future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    return this;
                }
            } else {
                this.onSuccess.add(consumer);
                return this;
            }
        }
        consumer.accept(value);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<T> onFailure(Consumer<Throwable> consumer) {
        Throwable value;
        Objects.requireNonNull(consumer);
        SolvableFuture<T> solvableFuture = this.future;
        synchronized (solvableFuture) {
            if (this.future.isDone() || this.future.isCancelled()) {
                try {
                    this.future.get();
                    return this;
                }
                catch (InterruptedException e) {
                    value = e;
                }
                catch (ExecutionException e) {
                    value = e.getCause();
                }
            } else {
                this.onError.add(consumer);
                return this;
            }
        }
        consumer.accept(value);
        return this;
    }

    @Override
    public Promise<T> onComplete(Consumer<Try<T>> consumer) {
        Objects.requireNonNull(consumer);
        return this.onSuccess(t -> consumer.accept(Try.success(t))).onFailure(throwable -> consumer.accept(Try.failure(throwable)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean solve(Try<T> response) {
        SolvableFuture<T> solvableFuture = this.future;
        synchronized (solvableFuture) {
            return this.future.solve(response);
        }
    }

    protected SolvableFuture<T> createFuture(Consumer<Try<T>> callbackOnComplete) {
        return new SolvableFuture<T>(callbackOnComplete);
    }

    private void notifyResponse(Try<T> response) {
        response.onSuccess((? super T s) -> {
            this.onSuccess.forEach(c -> c.accept(s));
            this.onSuccess.clear();
        }).onFailure((? super Throwable t) -> {
            this.onError.forEach(c -> c.accept(t));
            this.onError.clear();
        });
    }
}

