/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.data;

import java.util.function.Function;
import org.smallibs.control.Functor;
import org.smallibs.control.Monad;
import org.smallibs.data.Maybe;
import org.smallibs.data.Try;
import org.smallibs.exception.NoValueException;
import org.smallibs.type.HK;

public enum MaybeHelper {


    public static <T> Monad<Maybe, T, Maybe<T>> monad(Maybe<T> maybe) {
        return new Monadic(maybe);
    }

    public static <T> Try<T> toTry(Maybe<T> maybe) {
        return maybe.map(Try::success).orElse(Try.failure(new NoValueException()));
    }

    private static <B, Self extends HK<Maybe, B, Self>> HK<Maybe, B, Maybe<B>> specialize(HK<Maybe, B, Self> app) {
        return app;
    }

    private static <B, Self extends HK<Maybe, B, Self>> HK<Maybe, B, Self> generalize(HK<Maybe, B, Maybe<B>> app) {
        return app;
    }

    static final class Monadic<T>
    implements Monad<Maybe, T, Maybe<T>> {
        private final Maybe<T> aMaybe;

        private Monadic(Maybe<T> aMaybe) {
            this.aMaybe = aMaybe;
        }

        @Override
        public <B, NSelf extends HK<Maybe, B, NSelf>> HK<Maybe, B, NSelf> map(Function<? super T, ? extends B> function) {
            return MaybeHelper.generalize(new Monadic<B>(this.aMaybe.map(function)));
        }

        @Override
        public <B, NSelf extends HK<Maybe, B, NSelf>> HK<Maybe, B, NSelf> flatmap(Function<? super T, HK<Maybe, B, NSelf>> function) {
            Function<Object, Maybe> tMaybeFunction = t -> {
                HK applied = (HK)function.apply(t);
                return (Maybe)MaybeHelper.specialize(applied).self();
            };
            return MaybeHelper.generalize(new Monadic(this.aMaybe.flatmap(tMaybeFunction)));
        }

        @Override
        public <T1> T1 apply(Function<HK<Maybe, T, Maybe<T>>, T1> f) {
            return this.aMaybe.apply(f);
        }

        @Override
        public <B, NSelf extends HK<Maybe, B, NSelf>> HK<Maybe, B, NSelf> apply(Functor<Maybe, Function<? super T, ? extends B>, ?> functor) {
            return MaybeHelper.generalize(new Monadic(this.aMaybe.flatmap((? super T a) -> {
                HK map = functor.map((? super A bFunction) -> bFunction.apply(a));
                return (Maybe)MaybeHelper.specialize(map).self();
            })));
        }

        @Override
        public Maybe<T> self() {
            return this.aMaybe;
        }
    }
}

