/*
 * Decompiled with CFR 0.152.
 */
package org.smallibs.util;

import java.util.function.Function;
import org.smallibs.data.Try;
import org.smallibs.util.FunctionWithError;

public interface FunctionsHelper {
    public static <T, R> FunctionWithError<T, R> fromFunction(Function<T, R> function) {
        return function::apply;
    }

    public static <T, R> Function<T, Try<R>> toFunction(FunctionWithError<T, R> function) {
        return t -> {
            try {
                return Try.success(function.apply(t));
            }
            catch (Throwable throwable) {
                return Try.failure(throwable);
            }
        };
    }
}

