/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.artifact.maven;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.ConservativeAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.smallmind.artifact.maven.MavenCoordinate;

public class MavenRepository {
    private static final RepositorySystem REPOSITORY_SYSTEM;
    private final Settings settings;
    private final ProxySelector proxySelector;
    private final MirrorSelector mirrorSelector;
    private final AuthenticationSelector authenticationSelector;
    private final Map<Object, Object> configProps = new LinkedHashMap<Object, Object>();
    private final List<Profile> profileList;
    private final List<RemoteRepository> remoteRepositoryList;
    private boolean offline;

    public MavenRepository(String repositoryId, boolean offline) throws SettingsBuildingException {
        this(System.getProperty("user.home") + "/.m2", repositoryId, offline);
    }

    public MavenRepository(String settingsDirectory, String repositoryId, boolean offline) throws SettingsBuildingException {
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        this.offline = offline;
        request.setGlobalSettingsFile(new File((settingsDirectory == null || settingsDirectory.isEmpty() ? System.getProperty("user.home") + "/.m2" : settingsDirectory) + "/settings.xml"));
        this.settings = new DefaultSettingsBuilderFactory().newInstance().build((SettingsBuildingRequest)request).getEffectiveSettings();
        this.profileList = this.settings.getProfiles();
        this.configProps.put("aether.connector.userAgent", this.getUserAgent(repositoryId));
        this.proxySelector = this.getProxySelector(this.settings);
        this.mirrorSelector = this.getMirrorSelector(this.settings);
        this.authenticationSelector = this.getAuthenticationSelector(this.settings);
        this.remoteRepositoryList = this.initRepositories(this.authenticationSelector, this.mirrorSelector, this.settings);
    }

    public DefaultRepositorySystemSession generateSession() {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setOffline(this.offline);
        session.setCache((RepositoryCache)new DefaultRepositoryCache());
        session.setConfigProperties(this.configProps);
        if (this.profileList != null && !this.profileList.isEmpty()) {
            for (Profile profile : this.settings.getProfiles()) {
                session.setUserProperties((Map)profile.getProperties());
            }
        }
        session.setProxySelector(this.proxySelector);
        session.setMirrorSelector(this.mirrorSelector);
        session.setAuthenticationSelector(this.authenticationSelector);
        session.setLocalRepositoryManager(this.getLocalRepoMan(this.settings, REPOSITORY_SYSTEM, (RepositorySystemSession)session));
        return session;
    }

    public Artifact acquireArtifact(DefaultRepositorySystemSession session, MavenCoordinate mavenCoordinate) throws ArtifactResolutionException {
        return this.acquireArtifact(session, (Artifact)new DefaultArtifact(mavenCoordinate.getGroupId(), mavenCoordinate.getArtifactId(), mavenCoordinate.getClassifier(), mavenCoordinate.getExtension(), mavenCoordinate.getVersion()));
    }

    public Artifact acquireArtifact(DefaultRepositorySystemSession session, Artifact artifact) throws ArtifactResolutionException {
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(artifact);
        artifactRequest.setRepositories(this.remoteRepositoryList);
        return REPOSITORY_SYSTEM.resolveArtifact((RepositorySystemSession)session, artifactRequest).getArtifact();
    }

    public Artifact[] resolve(final DefaultRepositorySystemSession session, Artifact artifact) throws DependencyCollectionException, DependencyResolutionException {
        final HashSet visitedSet = new HashSet();
        final HashSet artifactSet = new HashSet();
        DependencyNode dependencyNode = REPOSITORY_SYSTEM.collectDependencies((RepositorySystemSession)session, new CollectRequest().setRoot(new Dependency(artifact, "compile"))).getRoot();
        dependencyNode.accept(new DependencyVisitor(){

            public boolean visitEnter(DependencyNode node) {
                if (visitedSet.add(node)) {
                    Dependency dependency = node.getDependency();
                    if (dependency != null && !dependency.isOptional()) {
                        Artifact artifact = dependency.getArtifact();
                        if (artifact.getFile() == null) {
                            try {
                                artifact = MavenRepository.this.acquireArtifact(session, artifact);
                            }
                            catch (ArtifactResolutionException artifactResolutionException) {
                                throw new RuntimeException(artifactResolutionException);
                            }
                        }
                        artifactSet.add(artifact);
                    }
                    return true;
                }
                return false;
            }

            public boolean visitLeave(DependencyNode node) {
                return true;
            }
        });
        REPOSITORY_SYSTEM.resolveDependencies((RepositorySystemSession)session, new DependencyRequest().setRoot(dependencyNode));
        Artifact[] artifacts = new Artifact[artifactSet.size()];
        artifactSet.toArray(artifacts);
        return artifacts;
    }

    private String getUserAgent(String repositoryId) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Maven-Repository/").append(repositoryId);
        buffer.append(" (");
        buffer.append("Java ").append(System.getProperty("java.version"));
        buffer.append("; ");
        buffer.append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version"));
        buffer.append(")");
        buffer.append(" Aether");
        return buffer.toString();
    }

    private List<RemoteRepository> initRepositories(AuthenticationSelector authenticationSelector, MirrorSelector mirrorSelector, Settings settings) {
        LinkedList<RemoteRepository> remoteRepositoryList = new LinkedList<RemoteRepository>();
        for (Profile profile : settings.getProfiles()) {
            if (!this.isProfileActive(settings, profile)) continue;
            for (Repository repository : profile.getRepositories()) {
                this.constructRemoteRepository(authenticationSelector, mirrorSelector, remoteRepositoryList, repository);
            }
            for (Repository repository : profile.getPluginRepositories()) {
                this.constructRemoteRepository(authenticationSelector, mirrorSelector, remoteRepositoryList, repository);
            }
        }
        return remoteRepositoryList;
    }

    private boolean isProfileActive(Settings settings, Profile profile) {
        return settings.getActiveProfiles().contains(profile.getId()) || profile.getActivation() != null && profile.getActivation().isActiveByDefault();
    }

    private void constructRemoteRepository(AuthenticationSelector authenticationSelector, MirrorSelector mirrorSelector, List<RemoteRepository> remoteRepositoryList, Repository repository) {
        RemoteRepository remoteRepository = new RemoteRepository.Builder(repository.getId(), repository.getLayout(), repository.getUrl()).setReleasePolicy(new RepositoryPolicy(true, "always", "warn")).setSnapshotPolicy(new RepositoryPolicy(true, "always", "warn")).build();
        RemoteRepository mirrorRepository = mirrorSelector.getMirror(remoteRepository);
        RemoteRepository coercedRepository = mirrorRepository != null ? mirrorRepository : remoteRepository;
        remoteRepositoryList.add(new RemoteRepository.Builder(coercedRepository).setAuthentication(authenticationSelector.getAuthentication(coercedRepository)).build());
    }

    private ProxySelector getProxySelector(Settings settings) {
        DefaultProxySelector selector = new DefaultProxySelector();
        for (org.apache.maven.settings.Proxy proxy : settings.getProxies()) {
            AuthenticationBuilder auth = new AuthenticationBuilder();
            auth.addUsername(proxy.getUsername()).addPassword(proxy.getPassword());
            selector.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth.build()), proxy.getNonProxyHosts());
        }
        return selector;
    }

    private MirrorSelector getMirrorSelector(Settings settings) {
        DefaultMirrorSelector selector = new DefaultMirrorSelector();
        for (Mirror mirror : settings.getMirrors()) {
            selector.add(String.valueOf(mirror.getId()), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        return selector;
    }

    private AuthenticationSelector getAuthenticationSelector(Settings settings) {
        DefaultAuthenticationSelector selector = new DefaultAuthenticationSelector();
        for (Server server : settings.getServers()) {
            AuthenticationBuilder auth = new AuthenticationBuilder();
            auth.addUsername(server.getUsername()).addPassword(server.getPassword());
            auth.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            selector.add(server.getId(), auth.build());
        }
        return new ConservativeAuthenticationSelector((AuthenticationSelector)selector);
    }

    private LocalRepositoryManager getLocalRepoMan(Settings settings, RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession) {
        LocalRepository repo = new LocalRepository(this.getDefaultLocalRepoDir(settings));
        return repositorySystem.newLocalRepositoryManager(repositorySystemSession, repo);
    }

    private File getDefaultLocalRepoDir(Settings settings) {
        if (settings.getLocalRepository() != null) {
            return new File(settings.getLocalRepository());
        }
        return new File(System.getProperty("user.home") + "/.m2/repository");
    }

    static {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.setServices(ModelBuilder.class, (Object[])new ModelBuilder[]{new DefaultModelBuilderFactory().newInstance()});
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        REPOSITORY_SYSTEM = (RepositorySystem)locator.getService(RepositorySystem.class);
    }
}

