/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.artifact.maven;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.smallmind.artifact.maven.ArtifactTag;
import org.smallmind.artifact.maven.MavenCoordinate;
import org.smallmind.artifact.maven.MavenRepository;
import org.smallmind.artifact.maven.MavenScannerEvent;
import org.smallmind.artifact.maven.MavenScannerListener;
import org.smallmind.nutsnbolts.lang.ClassGate;
import org.smallmind.nutsnbolts.lang.ClasspathClassGate;
import org.smallmind.nutsnbolts.lang.GatingClassLoader;
import org.smallmind.nutsnbolts.time.Stint;
import org.smallmind.scribe.pen.LoggerManager;

public class MavenScanner {
    private final LinkedList<MavenScannerListener> listenerList = new LinkedList();
    private final Stint cycleStint;
    private final MavenRepository mavenRepository;
    private final MavenCoordinate[] mavenCoordinates;
    private final ArtifactTag[] artifactTags;
    private ScannerWorker scannerWorker;
    private State state = State.STOPPED;

    public MavenScanner(String repositoryId, boolean offline, Stint cycleStint, MavenCoordinate ... mavenCoordinates) throws SettingsBuildingException {
        this(new MavenRepository(repositoryId, offline), cycleStint, mavenCoordinates);
    }

    public MavenScanner(String settingsDirectory, String repositoryId, boolean offline, Stint cycleStint, MavenCoordinate ... mavenCoordinates) throws SettingsBuildingException {
        this(new MavenRepository(settingsDirectory, repositoryId, offline), cycleStint, mavenCoordinates);
    }

    private MavenScanner(MavenRepository mavenRepository, Stint cycleStint, MavenCoordinate ... mavenCoordinates) {
        if (cycleStint == null) {
            throw new IllegalArgumentException("Must provide a cycle duration");
        }
        if (mavenCoordinates == null) {
            throw new IllegalArgumentException("Must provide some maven coordinates");
        }
        this.mavenRepository = mavenRepository;
        this.cycleStint = cycleStint;
        this.mavenCoordinates = mavenCoordinates;
        this.artifactTags = new ArtifactTag[mavenCoordinates.length];
    }

    public synchronized void addMavenScannerListener(MavenScannerListener listener) {
        this.listenerList.add(listener);
    }

    public synchronized void removeMavenScannerListener(MavenScannerListener listener) {
        this.listenerList.remove(listener);
    }

    public synchronized void start() throws DependencyCollectionException, DependencyResolutionException, ArtifactResolutionException {
        if (this.state.equals((Object)State.STOPPED)) {
            this.updateArtifact();
            this.scannerWorker = new ScannerWorker();
            Thread workerThread = new Thread(this.scannerWorker);
            workerThread.setDaemon(true);
            workerThread.start();
            this.state = State.STARTED;
        }
    }

    public synchronized void stop() throws InterruptedException {
        if (this.state.equals((Object)State.STARTED)) {
            if (this.scannerWorker != null) {
                this.scannerWorker.stop();
            }
            this.state = State.STOPPED;
        }
    }

    private synchronized void updateArtifact() throws DependencyCollectionException, DependencyResolutionException, ArtifactResolutionException {
        DefaultRepositorySystemSession session = this.mavenRepository.generateSession();
        HashMap<Artifact, Artifact> artifactDeltaMap = new HashMap<Artifact, Artifact>();
        HashSet<Artifact> dependentArtifactSet = new HashSet<Artifact>();
        LinkedList<ClasspathClassGate> classGateList = new LinkedList<ClasspathClassGate>();
        for (int index = 0; index < this.mavenCoordinates.length; ++index) {
            Artifact[] dependentArtifacts;
            ArtifactTag currentArtifactTag = new ArtifactTag(this.mavenRepository.acquireArtifact(session, this.mavenCoordinates[index]));
            if (currentArtifactTag.equals(this.artifactTags[index])) continue;
            for (Artifact dependentArtifact : dependentArtifacts = this.mavenRepository.resolve(session, currentArtifactTag.getArtifact())) {
                if (!dependentArtifactSet.add(dependentArtifact)) continue;
                classGateList.add(new ClasspathClassGate(dependentArtifact.getFile().getAbsolutePath()));
            }
            artifactDeltaMap.put(currentArtifactTag.getArtifact(), this.artifactTags[index] == null ? null : this.artifactTags[index].getArtifact());
            this.artifactTags[index] = currentArtifactTag;
        }
        if (!classGateList.isEmpty()) {
            ClassGate[] classGates = new ClassGate[classGateList.size()];
            classGateList.toArray(classGates);
            GatingClassLoader gatingClassLoader = new GatingClassLoader(Thread.currentThread().getContextClassLoader(), -1, classGates);
            MavenScannerEvent event = new MavenScannerEvent(this, artifactDeltaMap, this.artifactTags, (ClassLoader)gatingClassLoader);
            for (MavenScannerListener listener : this.listenerList) {
                listener.artifactChange(event);
            }
        }
    }

    protected void finalize() throws InterruptedException {
        this.stop();
    }

    private class ScannerWorker
    implements Runnable {
        private CountDownLatch finishLatch = new CountDownLatch(1);
        private CountDownLatch exitLatch = new CountDownLatch(1);

        private ScannerWorker() {
        }

        public void stop() throws InterruptedException {
            this.finishLatch.countDown();
            this.exitLatch.await();
        }

        @Override
        public void run() {
            try {
                do {
                    try {
                        MavenScanner.this.updateArtifact();
                    }
                    catch (Exception exception) {
                        LoggerManager.getLogger(MavenScanner.class).error((Throwable)exception);
                    }
                } while (!this.finishLatch.await(MavenScanner.this.cycleStint.getTime(), MavenScanner.this.cycleStint.getTimeUnit()));
            }
            catch (InterruptedException interruptedException) {
                this.finishLatch.countDown();
            }
            finally {
                this.exitLatch.countDown();
            }
        }
    }

    private static enum State {
        STARTED,
        STOPPED;

    }
}

