/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.collector.jmx;

import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.smallmind.claxon.collector.jmx.MeterDynamicMbean;
import org.smallmind.claxon.registry.PushCollector;
import org.smallmind.claxon.registry.Quantity;
import org.smallmind.claxon.registry.Tag;

public class JMXCollector
extends PushCollector {
    private final MBeanServer server;

    public JMXCollector(MBeanServer server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(String meterName, Tag[] tags, Quantity[] quantities) throws MalformedObjectNameException, NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, InstanceNotFoundException, ReflectionException {
        ObjectName objectName;
        MBeanServer tag;
        int n;
        int n2;
        Tag[] tagArray;
        AttributeList attributeList = new AttributeList();
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        if (tags != null && tags.length > 0) {
            tagArray = tags;
            n2 = tags.length;
            n = 0;
            while (n < n2) {
                tag = tagArray[n];
                tagTable.put(tag.getKey(), tag.getValue());
                ++n;
            }
        }
        if (!this.server.isRegistered(objectName = new ObjectName(meterName, tagTable))) {
            tag = this.server;
            synchronized (tag) {
                if (!this.server.isRegistered(objectName)) {
                    this.server.registerMBean(new MeterDynamicMbean(meterName, tags, quantities), objectName);
                }
            }
        }
        tagArray = quantities;
        n2 = quantities.length;
        n = 0;
        while (n < n2) {
            Tag quantity = tagArray[n];
            attributeList.add(new Attribute(quantity.getName(), quantity.getValue()));
            ++n;
        }
        this.server.setAttributes(objectName, attributeList);
    }
}

