/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.collector.prometheus;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.smallmind.claxon.registry.PullCollector;
import org.smallmind.claxon.registry.Quantity;
import org.smallmind.claxon.registry.Tag;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;

public class PrometheusCollector
extends PullCollector<String> {
    private ConcurrentLinkedQueue<String> rowQueue = new ConcurrentLinkedQueue();

    public void record(String meterName, Tag[] tags, Quantity[] quantities) {
        int n;
        StringBuilder identityBuilder = this.mangle(meterName, new StringBuilder());
        StringBuilder labelBuilder = null;
        long nowInSeconds = System.currentTimeMillis() / 1000L;
        if (tags != null && tags.length > 0) {
            labelBuilder = new StringBuilder();
            boolean first = true;
            labelBuilder.append('{');
            Tag[] tagArray = tags;
            int n2 = tags.length;
            n = 0;
            while (n < n2) {
                Tag tag = tagArray[n];
                if (!first) {
                    labelBuilder.append(',');
                }
                this.mangle(tag.getKey(), labelBuilder).append("=\"").append(tag.getValue()).append('\"');
                first = false;
                ++n;
            }
            labelBuilder.append("} ");
        }
        Quantity[] quantityArray = quantities;
        n = quantities.length;
        int n3 = 0;
        while (n3 < n) {
            Quantity quantity = quantityArray[n3];
            StringBuilder rowBuilder = new StringBuilder(identityBuilder);
            this.mangle(quantity.getName(), rowBuilder.append('_'));
            if (labelBuilder != null) {
                rowBuilder.append((CharSequence)labelBuilder);
            }
            rowBuilder.append(' ').append(quantity.getValue()).append(' ').append(nowInSeconds);
            this.rowQueue.add(rowBuilder.toString());
            ++n3;
        }
    }

    public String emit() {
        String row;
        if (this.rowQueue.isEmpty()) {
            return "";
        }
        StringBuilder outputBuilder = new StringBuilder();
        while ((row = this.rowQueue.poll()) != null) {
            outputBuilder.append(row).append('\n');
        }
        return outputBuilder.length() == 0 ? "" : outputBuilder.toString();
    }

    private StringBuilder mangle(String original, StringBuilder mangledBuilder) {
        Letter state = Letter.UNKNOWN;
        int index = 0;
        while (index < original.length()) {
            Letter priorState = state;
            char singleChar = original.charAt(index);
            if (singleChar >= 'a' && singleChar <= 'z') {
                state = Letter.LOWER;
            } else if (singleChar >= 'A' && singleChar <= 'Z') {
                state = Letter.UPPER;
            } else if (singleChar >= '0' && singleChar <= '9') {
                if (index == 0) {
                    mangledBuilder.append('_');
                }
                state = Letter.DIGIT;
            } else {
                if (singleChar == '.') {
                    singleChar = '-';
                } else if (singleChar != '-') {
                    singleChar = '_';
                }
                state = Letter.PUNCTUATION;
            }
            switch (state) {
                case PUNCTUATION: {
                    mangledBuilder.append(singleChar);
                    break;
                }
                case UPPER: {
                    if (Letter.LOWER.equals((Object)priorState)) {
                        mangledBuilder.append('_');
                    }
                    mangledBuilder.append(singleChar);
                    break;
                }
                case LOWER: {
                    if (Letter.UPPER.equals((Object)priorState)) {
                        mangledBuilder.append('_');
                    }
                    mangledBuilder.append(singleChar);
                    break;
                }
                case DIGIT: {
                    mangledBuilder.append(singleChar);
                    break;
                }
                default: {
                    throw new UnknownSwitchCaseException(state.name(), new Object[0]);
                }
            }
            ++index;
        }
        return mangledBuilder;
    }

    private static enum Letter {
        UPPER,
        LOWER,
        DIGIT,
        PUNCTUATION,
        UNKNOWN;

    }
}

