/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.emitter.jmx;

import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import org.smallmind.claxon.registry.Quantity;
import org.smallmind.claxon.registry.Tag;

public class MeterDynamicMbean
implements DynamicMBean {
    private final MBeanInfo mBeanInfo;
    private final HashSet<String> attributeNameSet = new HashSet();
    private final ConcurrentHashMap<String, Double> valueMap = new ConcurrentHashMap();

    public MeterDynamicMbean(String name, Tag[] tags, Quantity[] quantities) {
        int n;
        int n2;
        Tag[] tagArray;
        MBeanAttributeInfo[] attributeInfos = new MBeanAttributeInfo[quantities == null ? 0 : quantities.length];
        StringBuilder descriptionBuilder = new StringBuilder("Meter MBean(name=").append(name).append(", tags[");
        if (tags != null && tags.length > 0) {
            boolean first = true;
            tagArray = tags;
            n2 = tags.length;
            n = 0;
            while (n < n2) {
                Tag tag = tagArray[n];
                if (!first) {
                    descriptionBuilder.append(", ");
                }
                descriptionBuilder.append(tag.getKey()).append("=").append(tag.getValue());
                first = false;
                ++n;
            }
        }
        descriptionBuilder.append("])");
        if (quantities != null && quantities.length > 0) {
            int index = 0;
            tagArray = quantities;
            n2 = quantities.length;
            n = 0;
            while (n < n2) {
                Tag quantity = tagArray[n];
                this.attributeNameSet.add(quantity.getName());
                attributeInfos[index++] = new MBeanAttributeInfo(quantity.getName(), Double.class.getName(), quantity.getName(), true, false, false);
                ++n;
            }
        }
        this.mBeanInfo = new MBeanInfo(MeterDynamicMbean.class.getName(), descriptionBuilder.toString(), attributeInfos, null, null, null);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException {
        if (this.attributeNameSet.contains(attribute)) {
            Double value = this.valueMap.get(attribute);
            return value == null ? 0.0 : value;
        }
        throw new AttributeNotFoundException(attribute);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException {
        if (!this.attributeNameSet.contains(attribute.getName())) throw new AttributeNotFoundException(attribute.getName());
        if (Number.class.isAssignableFrom(attribute.getValue().getClass())) {
            this.valueMap.put(attribute.getName(), ((Number)attribute.getValue()).doubleValue());
            return;
        } else {
            if (!String.class.equals(attribute.getValue().getClass())) throw new InvalidAttributeValueException("Requires a double value");
            this.valueMap.put(attribute.getName(), Double.parseDouble((String)attribute.getValue()));
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList attributeList = new AttributeList();
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            Double value = this.valueMap.get(attribute);
            if (value != null) {
                attributeList.add(new Attribute(attribute, value));
            }
            ++n2;
        }
        return attributeList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList setAttributeList = new AttributeList();
        for (Object obj : attributes) {
            if (!(obj instanceof Attribute) || !this.attributeNameSet.contains(((Attribute)obj).getName())) continue;
            if (Double.TYPE.equals(((Attribute)obj).getValue().getClass())) {
                setAttributeList.add(obj);
                this.valueMap.put(((Attribute)obj).getName(), (double)((Double)((Attribute)obj).getValue()));
                continue;
            }
            if (Double.class.equals(((Attribute)obj).getValue().getClass())) {
                setAttributeList.add(obj);
                this.valueMap.put(((Attribute)obj).getName(), (Double)((Attribute)obj).getValue());
                continue;
            }
            if (!String.class.equals(((Attribute)obj).getValue().getClass())) continue;
            setAttributeList.add(obj);
            this.valueMap.put(((Attribute)obj).getName(), new Double((String)((Attribute)obj).getValue()));
        }
        return setAttributeList;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) {
        throw new UnsupportedOperationException(actionName);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mBeanInfo;
    }
}

