/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.emitter.prometheus;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.smallmind.claxon.registry.PullEmitter;
import org.smallmind.claxon.registry.Quantity;
import org.smallmind.claxon.registry.Tag;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;

public class PrometheusEmitter
extends PullEmitter<String> {
    private ConcurrentHashMap<PrometheusKey, Double> readMap = new ConcurrentHashMap();
    private volatile ConcurrentHashMap<PrometheusKey, Double> writeMap = new ConcurrentHashMap();

    public void record(String meterName, Tag[] tags, Quantity[] quantities) {
        Quantity[] quantityArray = quantities;
        int n = quantities.length;
        int n2 = 0;
        while (n2 < n) {
            Quantity quantity = quantityArray[n2];
            this.writeMap.put(new PrometheusKey(meterName, tags, quantity.getName()), quantity.getValue());
            ++n2;
        }
    }

    public synchronized String emit() {
        StringBuilder outputBuilder = new StringBuilder();
        ConcurrentHashMap<PrometheusKey, Double> tempMap = this.readMap;
        this.readMap = this.writeMap;
        this.writeMap = tempMap;
        for (Map.Entry<PrometheusKey, Double> traceEntry : this.readMap.entrySet()) {
            this.format(outputBuilder, traceEntry.getKey()).append(' ').append(this.fromDouble(traceEntry.getValue())).append('\n');
        }
        outputBuilder.append("# EOF\n");
        this.readMap.clear();
        return outputBuilder.toString();
    }

    private String fromDouble(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return "+Inf";
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        if (Double.isNaN(value)) {
            return "NaN";
        }
        if (value == 0.0) {
            return "0";
        }
        return Double.toString(value);
    }

    private StringBuilder format(StringBuilder outputBuilder, PrometheusKey prometheusKey) {
        this.mangle(outputBuilder, prometheusKey.getMeterName()).append(':');
        this.mangle(outputBuilder, prometheusKey.getQuantityName());
        if (prometheusKey.getTags() != null && prometheusKey.getTags().length > 0) {
            boolean first = true;
            outputBuilder.append('{');
            Tag[] tagArray = prometheusKey.getTags();
            int n = tagArray.length;
            int n2 = 0;
            while (n2 < n) {
                Tag tag = tagArray[n2];
                if (!first) {
                    outputBuilder.append(',');
                }
                this.mangle(outputBuilder, tag.getKey()).append("=\"").append(tag.getValue()).append('\"');
                first = false;
                ++n2;
            }
            outputBuilder.append("}");
        }
        return outputBuilder;
    }

    private StringBuilder mangle(StringBuilder outputBuilder, String original) {
        Letter state = Letter.UNKNOWN;
        int index = 0;
        while (index < original.length()) {
            Letter priorState = state;
            char singleChar = original.charAt(index);
            if (singleChar >= 'a' && singleChar <= 'z') {
                state = Letter.LOWER;
            } else if (singleChar >= 'A' && singleChar <= 'Z') {
                state = Letter.UPPER;
            } else if (singleChar >= '0' && singleChar <= '9') {
                if (index == 0) {
                    outputBuilder.append('_');
                }
                state = Letter.DIGIT;
            } else {
                singleChar = '_';
                state = Letter.PUNCTUATION;
            }
            switch (state) {
                case PUNCTUATION: {
                    outputBuilder.append(singleChar);
                    break;
                }
                case UPPER: {
                    if (Letter.LOWER.equals((Object)priorState)) {
                        outputBuilder.append('_');
                    }
                    outputBuilder.append(singleChar);
                    break;
                }
                case LOWER: {
                    if (Letter.UPPER.equals((Object)priorState)) {
                        outputBuilder.append('_');
                    }
                    outputBuilder.append(singleChar);
                    break;
                }
                case DIGIT: {
                    outputBuilder.append(singleChar);
                    break;
                }
                default: {
                    throw new UnknownSwitchCaseException(state.name(), new Object[0]);
                }
            }
            ++index;
        }
        return outputBuilder;
    }

    private static enum Letter {
        UPPER,
        LOWER,
        DIGIT,
        PUNCTUATION,
        UNKNOWN;

    }

    private static class PrometheusKey {
        private final Tag[] tags;
        private final String meterName;
        private final String quantityName;

        public PrometheusKey(String meterName, Tag[] tags, String quantityName) {
            this.meterName = meterName;
            this.tags = tags;
            this.quantityName = quantityName;
        }

        public String getMeterName() {
            return this.meterName;
        }

        public Tag[] getTags() {
            return this.tags;
        }

        public String getQuantityName() {
            return this.quantityName;
        }

        public int hashCode() {
            return (this.meterName.hashCode() * 31 + this.quantityName.hashCode()) * 31 + (this.tags == null ? 0 : Arrays.hashCode(this.tags));
        }

        public boolean equals(Object obj) {
            return obj instanceof PrometheusKey && ((PrometheusKey)obj).getMeterName().equals(this.meterName) && ((PrometheusKey)obj).getQuantityName().equals(this.quantityName) && Arrays.equals(((PrometheusKey)obj).getTags(), this.tags);
        }
    }
}

