/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.claxon.exotic.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.function.Supplier;

public class MemoryPools {
    private static final MemoryUsage ZERO_MEMORY_USAGE = new MemoryUsage(0L, 0L, 0L, 0L);
    private final Supplier<MemoryUsage> edenMemoryPool;
    private final Supplier<MemoryUsage> survivorMemoryPool;
    private final Supplier<MemoryUsage> tenuredMemoryPool;

    public MemoryPools() {
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        MemoryPoolMXBean edenMemoryPoolMXBean = null;
        MemoryPoolMXBean survivorMemoryPoolMXBean = null;
        MemoryPoolMXBean oldMempryPoolMXBean = null;
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            switch (memoryPoolMXBean.getName()) {
                case "Par Eden Space": 
                case "G1 Eden Space": 
                case "PS Eden Space": {
                    edenMemoryPoolMXBean = memoryPoolMXBean;
                    break;
                }
                case "PS Survivor Space": 
                case "Par Survivor Space": 
                case "G1 Survivor Space": {
                    survivorMemoryPoolMXBean = memoryPoolMXBean;
                    break;
                }
                case "CMS Old Gen": 
                case "Shenandoah": 
                case "ZHeap": 
                case "G1 Old Gen": 
                case "PS Old Gen": {
                    oldMempryPoolMXBean = memoryPoolMXBean;
                }
            }
        }
        this.edenMemoryPool = edenMemoryPoolMXBean == null ? () -> ZERO_MEMORY_USAGE : edenMemoryPoolMXBean::getUsage;
        this.survivorMemoryPool = survivorMemoryPoolMXBean == null ? () -> ZERO_MEMORY_USAGE : survivorMemoryPoolMXBean::getUsage;
        this.tenuredMemoryPool = oldMempryPoolMXBean == null ? () -> ZERO_MEMORY_USAGE : oldMempryPoolMXBean::getUsage;
    }

    public MemoryUsage getEdenMemoryUsage() {
        return this.edenMemoryPool.get();
    }

    public MemoryUsage getSurvivorMemoryUsage() {
        return this.survivorMemoryPool.get();
    }

    public MemoryUsage getTenuredMemoryUsage() {
        return this.tenuredMemoryPool.get();
    }
}

